/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.util.UUID;
import org.docx4j.XmlUtils;
import org.docx4j.customXmlProperties.DatastoreItem;
import org.docx4j.customXmlProperties.ObjectFactory;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.model.datastorage.CustomXmlDataStorageImpl;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.w3c.dom.Document;

public class ContentControlsAddCustomXmlDataStoragePart {
    public static void main(String[] args) throws Exception {
        System.out.println("Creating package..");
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
        wordMLPackage.getMainDocumentPart().addStyledParagraphOfText("Title", "Hello world");
        wordMLPackage.getMainDocumentPart().addParagraphOfText("from docx4j!");
        CustomXmlDataStoragePart customXmlDataStoragePart = ContentControlsAddCustomXmlDataStoragePart.injectCustomXmlDataStoragePart((Part)wordMLPackage.getMainDocumentPart());
        ContentControlsAddCustomXmlDataStoragePart.addProperties(customXmlDataStoragePart);
        wordMLPackage.save(new File(String.valueOf(System.getProperty("user.dir")) + "/OUT_withCustomXmlDataStoragePart.docx"));
    }

    public static CustomXmlDataStoragePart injectCustomXmlDataStoragePart(Part parent) throws Exception {
        CustomXmlDataStoragePart customXmlDataStoragePart = new CustomXmlDataStoragePart();
        CustomXmlDataStorageImpl data = new CustomXmlDataStorageImpl();
        data.setDocument(ContentControlsAddCustomXmlDataStoragePart.createCustomXmlDocument());
        customXmlDataStoragePart.setData((CustomXmlDataStorage)data);
        parent.addTargetPart((Part)customXmlDataStoragePart, RelationshipsPart.AddPartBehaviour.RENAME_IF_NAME_EXISTS);
        return customXmlDataStoragePart;
    }

    public static void addProperties(CustomXmlDataStoragePart customXmlDataStoragePart) throws InvalidFormatException {
        CustomXmlDataStoragePropertiesPart part = new CustomXmlDataStoragePropertiesPart();
        ObjectFactory of = new ObjectFactory();
        DatastoreItem dsi = of.createDatastoreItem();
        String newItemId = "{" + UUID.randomUUID().toString() + "}";
        dsi.setItemID(newItemId);
        part.setJaxbElement((Object)dsi);
        customXmlDataStoragePart.addTargetPart((Part)part);
    }

    public static Document createCustomXmlDocument() {
        Document domDoc = XmlUtils.neww3cDomDocument();
        domDoc.appendChild(domDoc.createElement("someContent"));
        return domDoc;
    }
}

