/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.pdf.viaXSLFO.Conversion;
import org.docx4j.convert.out.pdf.viaXSLFO.PdfSettings;
import org.docx4j.diff.Differencer;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.wml.Body;
import org.docx4j.wml.Document;

public class CompareDocuments {
    public static JAXBContext context = Context.jc;

    public static void main(String[] args) throws Exception {
        String newerfilepath = String.valueOf(System.getProperty("user.dir")) + "/sample-docs/word/sample-docxv2.docx";
        String olderfilepath = String.valueOf(System.getProperty("user.dir")) + "/sample-docs/word/sample-docx.docx";
        WordprocessingMLPackage newerPackage = WordprocessingMLPackage.load((File)new File(newerfilepath));
        WordprocessingMLPackage olderPackage = WordprocessingMLPackage.load((File)new File(olderfilepath));
        Body newerBody = ((Document)newerPackage.getMainDocumentPart().getJaxbElement()).getBody();
        Body olderBody = ((Document)olderPackage.getMainDocumentPart().getJaxbElement()).getBody();
        System.out.println("Differencing..");
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        Calendar changeDate = null;
        Differencer pd = new Differencer();
        pd.setRelsDiffIdentifier("blagh");
        pd.diff(newerBody, olderBody, (Result)result, "someone", changeDate, newerPackage.getMainDocumentPart().getRelationshipsPart(), olderPackage.getMainDocumentPart().getRelationshipsPart());
        String contentStr = sw.toString();
        System.out.println("Result: \n\n " + contentStr);
        Body newBody = (Body)XmlUtils.unmarshalString((String)contentStr);
        ((Document)newerPackage.getMainDocumentPart().getJaxbElement()).setBody(newBody);
        RelationshipsPart rp = newerPackage.getMainDocumentPart().getRelationshipsPart();
        CompareDocuments.handleRels(pd, rp);
        newerPackage.setFontMapper((Mapper)new IdentityPlusMapper());
        Conversion c = new Conversion(newerPackage);
        FileOutputStream os = new FileOutputStream(String.valueOf(System.getProperty("user.dir")) + "/OUT_CompareDocuments.pdf");
        c.output((OutputStream)os, new PdfSettings());
        System.out.println("Saved " + System.getProperty("user.dir") + "/OUT_CompareDocuments.pdf");
    }

    private static void handleRels(Differencer pd, RelationshipsPart rp) {
        ArrayList<Relationship> relsToRemove = new ArrayList<Relationship>();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image")) continue;
            relsToRemove.add(r);
        }
        for (Relationship r : relsToRemove) {
            rp.removeRelationship(r);
        }
        List newRels = pd.getComposedRels();
        for (Relationship nr : newRels) {
            rp.addRelationship(nr);
        }
    }
}

