/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.samples;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTBookmark;
import org.docx4j.wml.CTMarkupRange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarksDeleter {
    protected static Logger log = LoggerFactory.getLogger(BookmarksDeleter.class);

    public static void main(String[] args) throws Exception {
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load((File)new File(String.valueOf(System.getProperty("user.dir")) + "/BookmarksDeleter.docx"));
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        BookmarksDeleter.fixRange(body.getContent(), "CTBookmark", "CTMarkupRange");
        System.out.println(XmlUtils.marshaltoString((Object)documentPart.getJaxbElement(), (boolean)true, (boolean)true));
    }

    private static void fixRange(List<Object> paragraphs, String startElement, String endElement) throws Exception {
        Object deleteMe;
        List theList;
        RangeTraverser rt = new RangeTraverser(startElement, endElement);
        new TraversalUtil(paragraphs, (TraversalUtil.Callback)rt);
        for (CTBookmark bm : rt.starts) {
            try {
                theList = null;
                theList = bm.getParent() instanceof List ? (List)bm.getParent() : ((ContentAccessor)bm.getParent()).getContent();
                deleteMe = null;
                for (Object ox : theList) {
                    if (!XmlUtils.unwrap(ox).equals(bm)) continue;
                    deleteMe = ox;
                    break;
                }
                if (deleteMe == null) continue;
                theList.remove(deleteMe);
            }
            catch (ClassCastException cce) {
                log.error(cce.getMessage(), (Throwable)cce);
            }
        }
        for (CTMarkupRange mr : rt.ends) {
            try {
                theList = null;
                theList = mr.getParent() instanceof List ? (List)mr.getParent() : ((ContentAccessor)mr.getParent()).getContent();
                deleteMe = null;
                for (Object ox : theList) {
                    if (!XmlUtils.unwrap(ox).equals(mr)) continue;
                    deleteMe = ox;
                    break;
                }
                if (deleteMe == null) continue;
                theList.remove(deleteMe);
            }
            catch (ClassCastException cce) {
                log.info(mr.getParent().getClass().getName());
                log.error(cce.getMessage(), (Throwable)cce);
            }
        }
    }

    private static boolean remove(List<Object> theList, Object bm) {
        for (Object ox : theList) {
            if (!XmlUtils.unwrap((Object)ox).equals(bm)) continue;
            return theList.remove(ox);
        }
        return false;
    }

    static class RangeTraverser
    extends TraversalUtil.CallbackImpl {
        List<CTBookmark> starts = new ArrayList<CTBookmark>();
        List<CTMarkupRange> ends = new ArrayList<CTMarkupRange>();
        List<Text> refs = new ArrayList<Text>();
        String startElement;
        String endElement;

        RangeTraverser(String startElement, String endElement) {
            this.startElement = "org.docx4j.wml." + startElement;
            this.endElement = "org.docx4j.wml." + endElement;
        }

        public List<Object> apply(Object o) {
            CTBookmark bookmark;
            if (o.getClass().getName().equals(this.startElement) && o instanceof CTBookmark) {
                bookmark = (CTBookmark)o;
                this.starts.add(bookmark);
            }
            if (o.getClass().getName().equals(this.endElement) && o instanceof CTMarkupRange) {
                bookmark = (CTMarkupRange)o;
                this.ends.add((CTMarkupRange)bookmark);
            }
            if (this.startElement.equals("org.docx4j.wml.CTBookmark") && o instanceof JAXBElement && ((JAXBElement)o).getName().getLocalPart().equals("instrText")) {
                this.refs.add((Text)XmlUtils.unwrap((Object)o));
            }
            return null;
        }

        public void walkJAXBElements(Object parent) {
            List children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    if (o instanceof JAXBElement && ((JAXBElement)o).getName().getLocalPart().equals("instrText")) {
                        Text t = (Text)XmlUtils.unwrap(o);
                        t.setParent(parent);
                    } else {
                        o = XmlUtils.unwrap(o);
                    }
                    if (o instanceof Child) {
                        ((Child)o).setParent(parent);
                    }
                    this.apply(o);
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
            }
        }
    }
}

