/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.wizard;

import aurora.ide.prototype.consultant.product.fsd.ExportFSDProgress;
import aurora.ide.prototype.consultant.product.fsd.FunctionDesc;
import aurora.ide.prototype.consultant.product.fsd.wizard.Messages;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import aurora.ide.prototype.consultant.view.wizard.FunctionFSDContentPage;
import aurora.ide.prototype.consultant.view.wizard.FunctionFSDDescPage;
import aurora.ide.swt.util.PageModel;
import aurora.ide.swt.util.UWizard;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import uncertain.composite.CompositeMap;

public class FunctionExportFSDWizard
extends UWizard {
    private FunctionFSDDescPage page1;
    private FunctionFSDContentPage page2;
    private Node projectNode;
    private CompositeMap loadProperties;
    private Node selectionNode;

    public FunctionExportFSDWizard(Shell shell, Node selectionNode) {
        super(shell);
        this.setNeedsProgressMonitor(true);
        this.projectNode = ResourceUtil.getProjectNode(selectionNode);
        this.loadProperties = this.loadProperties(selectionNode.getFile());
        this.selectionNode = selectionNode;
    }

    public void addPages() {
        this.page1 = new FunctionFSDDescPage("ProjectFSDDescPage", Messages.ExportWizard_1, null, this.loadProperties);
        this.page2 = new FunctionFSDContentPage("ProjectFSDContentPage", Messages.ExportWizard_3, null, this.selectionNode, this.projectNode, this.loadProperties);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
    }

    protected CompositeMap loadProperties(File file) {
        CompositeMap pp = ResourceUtil.loadFunctionProperties(file);
        ResourceUtil.copyProjectProperties(file, pp);
        return pp;
    }

    protected void saveProperties(CompositeMap map) throws IOException {
        File file = this.selectionNode.getFile();
        ResourceUtil.createFile(file, "quick_ui.function", map);
    }

    public boolean performFinish() {
        PageModel p2m = this.page2.getModel();
        PageModel p1m = this.page1.getModel();
        CompositeMap map = new CompositeMap("properties");
        this.page1.saveTOMap(map);
        this.page2.saveTOMap(map);
        try {
            this.saveProperties(map);
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)new ExportFSDProgress(p2m.getStringPropertyValue("fsd_docx_path"), FunctionDesc.create(p1m), (List)p2m.getPropertyValue("fsd_table_input"), p2m.getBooleanPropertyValue("only_save_logic")));
            return true;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }
}

