/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.util;

import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uncertain.composite.CompositeMap;

public class UIPViewerSortSeq {
    private static final int _100 = 100;
    private static final int step = 10;
    public static final String QUICK_UI_SORT = "quick_ui.sort";
    private Node node;
    private boolean isNeedReload;
    private Map<String, Integer> map;
    private int max = 100;
    private static final Map<Node, UIPViewerSortSeq> maps = new HashMap<Node, UIPViewerSortSeq>();

    public UIPViewerSortSeq(Node node) {
        this.node = node;
        this.isNeedReload = true;
        this.load();
    }

    private void load() {
        if (!this.isNeedReload) {
            return;
        }
        this.map = new HashMap<String, Integer>();
        CompositeMap loadProperties = this.loadProperties();
        this.isNeedReload = false;
        List<Node> children = this.node.getChildren();
        for (Node n : children) {
            int sortNum = this.getSortNum(n, loadProperties);
            this.map.put(n.getFile().getName(), sortNum);
        }
    }

    private int getSortNum(Node node, CompositeMap loadProperties) {
        List childsNotNull = loadProperties.getChildsNotNull();
        for (Object object : childsNotNull) {
            int int1;
            if (!(object instanceof CompositeMap) || !node.getFile().getName().equals(((CompositeMap)object).getText()) || -1 == (int1 = ((CompositeMap)object).getInt((Object)"num", -1))) continue;
            return int1;
        }
        return this.getSortNum(node);
    }

    public int getSortNum(Node node) {
        this.load();
        Integer integer = this.map.get(node.getFile().getName());
        return integer == null ? (this.max = this.max + 10) : integer;
    }

    public void changeSort(Node pre, Node next) {
        int sortNum1 = this.getSortNum(pre);
        int sortNum2 = this.getSortNum(next);
        this.setSortNum(pre, sortNum2);
        this.setSortNum(next, sortNum1);
        this.save();
    }

    public void setSortNum(Node node, int i) {
        if (this.map != null) {
            this.map.put(node.getFile().getName(), i);
        }
    }

    public void save() {
        CompositeMap sm = new CompositeMap("sorts");
        if (this.map != null) {
            Set<String> keySet = this.map.keySet();
            for (String s : keySet) {
                Integer integer = this.map.get(s);
                CompositeMap createChild = sm.createChild("sort");
                createChild.put((Object)"num", (Object)integer);
                createChild.setText(s);
            }
        }
        try {
            this.saveProperties(sm);
            this.isNeedReload = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected CompositeMap loadProperties() {
        if (this.node == null) {
            return new CompositeMap();
        }
        File file = this.node.getFile();
        CompositeMap pp = ResourceUtil.loadSortProperties(file);
        return pp == null ? new CompositeMap() : pp;
    }

    protected void saveProperties(CompositeMap map) throws IOException {
        File file = this.node.getFile();
        ResourceUtil.createFile(file, QUICK_UI_SORT, map);
    }

    public static UIPViewerSortSeq getUIPViewerSortSeq(Node node) {
        UIPViewerSortSeq uipViewerSortSeq = maps.get((Object)node);
        if (uipViewerSortSeq == null) {
            uipViewerSortSeq = new UIPViewerSortSeq(node);
            maps.put(node, new UIPViewerSortSeq(node));
        }
        return uipViewerSortSeq;
    }
}

