/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view.action;

import aurora.ide.helpers.FileDeleter;
import aurora.ide.prototype.consultant.view.NavViewSetting;
import aurora.ide.prototype.consultant.view.NavigationView;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.action.Messages;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;

public class RemoveLocalFolderAction
extends Action
implements ISelectionChangedListener {
    private NavigationView viewer;

    public RemoveLocalFolderAction(NavigationView viewer) {
        this.viewer = viewer;
        viewer.getViewSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectionChanged();
    }

    public void run() {
        Node[] nodes;
        boolean oc = MessageDialog.openConfirm((Shell)this.viewer.getViewer().getControl().getShell(), (String)"Confirm", (String)Messages.RemoveLocalFolderAction_1);
        if (!oc) {
            return;
        }
        Node node = this.viewer.getSelectionNode();
        if (node == null) {
            return;
        }
        Node[] nodeArray = nodes = this.viewer.findSamePathNodes(node);
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node n3 = nodeArray[n2];
            if (n3.getParent() != null && n3.getParent().isRoot()) {
                String queryFile = n3.getPath().toOSString();
                NavViewSetting vs = new NavViewSetting();
                vs.removeFolder(queryFile);
            }
            n3.getParent().removeChild(n3);
            this.viewer.getViewer().remove((Object)n3);
            ++n2;
        }
        FileDeleter.deleteDirectory((File)node.getFile());
    }

    private String queryFile() {
        Node selectionNode = this.viewer.getSelectionNode();
        if (selectionNode.getParent().isRoot()) {
            return selectionNode.getPath().toOSString();
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged();
    }

    private void selectionChanged() {
        Node selectionNode = this.viewer.getSelectionNode();
        if (selectionNode == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

