/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view;

import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.Root;
import aurora.ide.prototype.consultant.view.util.UIPViewerSortSeq;
import java.io.File;
import java.util.Comparator;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class CNFViewerSorter
extends ViewerSorter {
    private Comparator<Node> comparator = new Comparator<Node>(){

        @Override
        public int compare(Node an, Node bn) {
            File a = an.getFile();
            File b = bn.getFile();
            boolean aIsDir = a.isDirectory();
            boolean bIsDir = b.isDirectory();
            if (aIsDir && !bIsDir) {
                return -1;
            }
            if (bIsDir && !aIsDir) {
                return 1;
            }
            Node parent = an.getParent();
            if (parent == null || parent instanceof Root) {
                int compare = a.getName().compareToIgnoreCase(b.getName());
                if (compare == 0) {
                    compare = a.getName().compareTo(b.getName());
                }
                return compare;
            }
            UIPViewerSortSeq uipViewerSortSeq = UIPViewerSortSeq.getUIPViewerSortSeq(parent);
            return uipViewerSortSeq.getSortNum(bn) - uipViewerSortSeq.getSortNum(an);
        }
    };

    public int compare(Viewer viewer, Object o1, Object o2) {
        if (o1 instanceof Node && o2 instanceof Node) {
            return this.comparator.compare((Node)((Object)o1), (Node)((Object)o2));
        }
        return 0;
    }
}

