/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.view;

import java.io.File;
import java.util.Vector;

public class CNFContentHelper {
    private static final String DRIVE_A = "a:" + File.separator;
    private static final String DRIVE_B = "b:" + File.separator;
    private boolean initial = true;
    private File currentDirectory;

    File[] getRoots() {
        if (System.getProperty("os.name").indexOf("Windows") != -1) {
            Vector<File> list = new Vector<File>();
            list.add(new File(DRIVE_A));
            list.add(new File(DRIVE_B));
            char i = 'c';
            while (i <= 'z') {
                File drive = new File(String.valueOf(i) + ":" + File.separator);
                if (drive.isDirectory() && drive.exists()) {
                    list.add(drive);
                    if (this.initial && i == 'c') {
                        this.currentDirectory = drive;
                        this.initial = false;
                    }
                }
                i = (char)(i + '\u0001');
            }
            File[] roots = list.toArray(new File[list.size()]);
            CNFContentHelper.sortFiles(roots);
            return roots;
        }
        File root = new File(File.separator);
        if (this.initial) {
            this.currentDirectory = root;
            this.initial = false;
        }
        return new File[]{root};
    }

    public static File[] getDirectoryList(File file) {
        File[] list = file.listFiles();
        if (list == null) {
            return new File[0];
        }
        CNFContentHelper.sortFiles(list);
        return list;
    }

    static void sortFiles(File[] files) {
        CNFContentHelper.sortBlock(files, 0, files.length - 1, new File[files.length]);
    }

    private static void sortBlock(File[] files, int start, int end, File[] mergeTemp) {
        int length = end - start + 1;
        if (length < 8) {
            int i = end;
            while (i > start) {
                int j = end;
                while (j > start) {
                    if (CNFContentHelper.compareFiles(files[j - 1], files[j]) > 0) {
                        File temp = files[j];
                        files[j] = files[j - 1];
                        files[j - 1] = temp;
                    }
                    --j;
                }
                --i;
            }
            return;
        }
        int mid = (start + end) / 2;
        CNFContentHelper.sortBlock(files, start, mid, mergeTemp);
        CNFContentHelper.sortBlock(files, mid + 1, end, mergeTemp);
        int x = start;
        int y = mid + 1;
        int i = 0;
        while (i < length) {
            mergeTemp[i] = x > mid || y <= end && CNFContentHelper.compareFiles(files[x], files[y]) > 0 ? files[y++] : files[x++];
            ++i;
        }
        i = 0;
        while (i < length) {
            files[i + start] = mergeTemp[i];
            ++i;
        }
    }

    private static int compareFiles(File a, File b) {
        int compare = a.getName().compareToIgnoreCase(b.getName());
        if (compare == 0) {
            compare = a.getName().compareTo(b.getName());
        }
        return compare;
    }
}

