/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.fsd.wizard;

import aurora.ide.prototype.consultant.product.fsd.FunctionDesc;
import aurora.ide.prototype.consultant.product.fsd.wizard.FunctionDescPage;
import aurora.ide.prototype.consultant.product.fsd.wizard.Messages;
import aurora.ide.swt.util.GridLayoutUtil;
import aurora.ide.swt.util.TableContentProvider;
import aurora.ide.swt.util.TableLabelProvider;
import aurora.ide.swt.util.TextField;
import aurora.ide.swt.util.WidgetFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ContentDescPage
extends WizardPage {
    private String savePath;
    private List<String> uipFiles = new ArrayList<String>();
    private boolean onlySaveLogic = false;

    protected ContentDescPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(Messages.ContentDescPage_2);
    }

    public void createControl(Composite root) {
        Composite parent = WidgetFactory.composite((Composite)root);
        parent.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_1);
        Composite pathComposite = WidgetFactory.composite((Composite)parent);
        pathComposite.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_3);
        pathComposite.setLayoutData((Object)new GridData(768));
        final TextField tf = WidgetFactory.createTextButtonField((Composite)pathComposite, (String)Messages.ContentDescPage_0, (String)Messages.ContentDescPage_1);
        tf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Object source = e.getSource();
                if (source instanceof Text) {
                    ContentDescPage.this.setSavePath(((Text)source).getText());
                }
                ContentDescPage.this.verifyPage();
            }
        });
        tf.addButtonClickListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog sd = new FileDialog(ContentDescPage.this.getShell(), 8192);
                sd.setFileName(ContentDescPage.this.getDefaultFileName());
                sd.setFilterExtensions(new String[]{"*.docx"});
                sd.setOverwrite(true);
                String open = sd.open();
                if (open == null || open.length() < 1) {
                    return;
                }
                tf.setText(open);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button checked = new Button(parent, 32);
        checked.setLayoutData((Object)new GridData(768));
        checked.setText(Messages.ContentDescPage_3);
        checked.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContentDescPage.this.setOnlySaveLogic(checked.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite tableComposite = WidgetFactory.composite((Composite)parent);
        this.createTable(tableComposite);
        this.setControl((Control)parent);
        this.verifyPage();
    }

    protected String getDefaultFileName() {
        IWizard wizard = this.getWizard();
        IWizardPage page = wizard.getPage("FunctionDescPage");
        if (page instanceof FunctionDescPage) {
            FunctionDesc model = ((FunctionDescPage)page).getModel();
            return model.getPropertyValue("fun_code") + "_" + model.getPropertyValue("fun_name");
        }
        return "NO_NAME";
    }

    private void createTable(Composite tableComposite) {
        tableComposite.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_2);
        tableComposite.setLayoutData((Object)new GridData(768));
        final TableViewer tv = new TableViewer(tableComposite, 68352);
        Table table = tv.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 16384);
        column1.setWidth(128);
        column1.setText(Messages.ContentDescPage_5);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setWidth(193);
        column2.setText(Messages.ContentDescPage_6);
        tv.setContentProvider((IContentProvider)new TableContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)new TableLabelProvider(){

            public String getColumnText(Object element, int i) {
                if (element instanceof String) {
                    if (i == 0) {
                        Path p = new Path(element.toString());
                        return p.lastSegment();
                    }
                    if (i == 1) {
                        return element.toString();
                    }
                }
                return "";
            }
        });
        Composite buttonComposite = WidgetFactory.composite((Composite)tableComposite);
        buttonComposite.setLayout((Layout)GridLayoutUtil.COLUMN_LAYOUT_1);
        buttonComposite.setLayoutData((Object)new GridData(1040));
        Button add = WidgetFactory.button((Composite)buttonComposite, (String)Messages.ContentDescPage_8);
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ContentDescPage.this.getShell(), 4096);
                dialog.setText("Open File");
                dialog.setFilterExtensions(new String[]{"*.uip"});
                String path = dialog.open();
                if (path != null && path.length() > 0) {
                    ContentDescPage.this.getUipFiles().add(path);
                }
                tv.setInput(ContentDescPage.this.getUipFiles());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button del = WidgetFactory.button((Composite)buttonComposite, (String)Messages.ContentDescPage_10);
        del.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ISelection s = tv.getSelection();
                if (s instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)s;
                    List list = ss.toList();
                    ContentDescPage.this.getUipFiles().removeAll(list);
                    tv.setInput(ContentDescPage.this.getUipFiles());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button up = WidgetFactory.button((Composite)buttonComposite, (String)Messages.ContentDescPage_11);
        up.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContentDescPage.this.moveElement(tv, -1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button down = WidgetFactory.button((Composite)buttonComposite, (String)Messages.ContentDescPage_12);
        down.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContentDescPage.this.moveElement(tv, 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tv.setInput(this.getUipFiles());
    }

    protected boolean verifyPage() {
        if (this.getSavePath() == null || "".equals(this.getSavePath())) {
            this.setErrorMessage(Messages.ContentDescPage_14);
            this.setPageComplete(false);
            return false;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }

    public void moveElement(TableViewer tv, int i) {
        ISelection s = tv.getSelection();
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            String r1 = (String)ss.getFirstElement();
            int idx = this.getUipFiles().indexOf(r1);
            if (idx == -1) {
                return;
            }
            int idx2 = idx + i;
            if (idx2 < 0 || idx2 == this.getUipFiles().size()) {
                return;
            }
            String r2 = this.getUipFiles().get(idx2);
            this.getUipFiles().set(idx2, r1);
            this.getUipFiles().set(idx, r2);
            tv.setInput(this.getUipFiles());
        }
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public List<String> getUipFiles() {
        return this.uipFiles;
    }

    public void setUipFiles(List<String> uipFiles) {
        this.uipFiles = uipFiles;
    }

    public boolean isOnlySaveLogic() {
        return this.onlySaveLogic;
    }

    public void setOnlySaveLogic(boolean onlySaveLogic) {
        this.onlySaveLogic = onlySaveLogic;
    }
}

