/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.fsd;

import aurora.ide.prototype.consultant.product.fsd.FSDDocumentPackage;
import aurora.ide.prototype.consultant.product.fsd.FunctionDesc;
import aurora.ide.prototype.consultant.product.fsd.Messages;
import javax.xml.bind.JAXBException;
import org.docx4j.XmlUtils;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.SectionWrapper;
import org.docx4j.model.table.TblFactory;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.R;
import org.docx4j.wml.Tbl;
import org.docx4j.wml.TblPr;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Text;
import org.docx4j.wml.Tr;

public class FirstPage {
    private FSDDocumentPackage doc;
    private WordprocessingMLPackage wordMLPackage;
    private FunctionDesc function;

    public FirstPage(FSDDocumentPackage doc, FunctionDesc function) {
        this.doc = doc;
        this.wordMLPackage = doc.getWordMLPackage();
        this.function = function;
    }

    public void create() {
        MainDocumentPart mdp = this.doc.getMainDocumentPart();
        mdp.addStyledParagraphOfText("TitleBar", "");
        mdp.addStyledParagraphOfText("Title", "");
        mdp.addStyledParagraphOfText("Title", "HAND ENTERPRISE SOLUTIONS");
        String funCode = this.function.getFunCode();
        if (funCode != null && !"".equals(funCode)) {
            mdp.addStyledParagraphOfText("DocTitle2", funCode);
        }
        mdp.addStyledParagraphOfText("DocTitle3", this.function.getDocTitle());
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("Docinfo", "");
        this.createFirstInfo(mdp, Messages.FirstPage_16, this.function.getWriter());
        this.createFirstInfo(mdp, Messages.FirstPage_17, this.function.getCreateDate());
        this.createFirstInfo(mdp, Messages.FirstPage_18, this.function.getUpdateDate());
        this.createFirstInfo(mdp, Messages.FirstPage_19, this.function.getControlNo());
        this.createFirstInfo(mdp, Messages.FirstPage_20, this.function.getVer());
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("Docinfo", "");
        mdp.addStyledParagraphOfText("DocInfotabletitle", Messages.FirstPage_28);
        this.createTbl();
    }

    private void createFirstInfo(MainDocumentPart mdp, String name, String value) {
        P p = mdp.addStyledParagraphOfText("Docinfo", name);
        p.getContent().add(this.createTab());
        p.getContent().add(this.createText(value));
    }

    private R createTab() {
        ObjectFactory factory = Context.getWmlObjectFactory();
        R run = factory.createR();
        run.getContent().add(factory.createRTab());
        return run;
    }

    private R createText(String text) {
        ObjectFactory factory = Context.getWmlObjectFactory();
        R run = factory.createR();
        Text t = factory.createText();
        t.setValue(text);
        run.getContent().add(t);
        return run;
    }

    protected void createTbl() {
        WordprocessingMLPackage wordMLPackage = this.doc.getWordMLPackage();
        MainDocumentPart mdp = this.doc.getMainDocumentPart();
        int writableWidthTwips = ((SectionWrapper)wordMLPackage.getDocumentModel().getSections().get(0)).getPageDimensions().getWritableWidthTwips();
        int cols = 2;
        int cellWidthTwips = new Double(Math.floor(writableWidthTwips / cols)).intValue();
        Tbl tbl = TblFactory.createTable((int)3, (int)cols, (int)cellWidthTwips);
        String strTblPr = "<w:tblPr xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\"><w:tblStyle w:val=\"TableGrid\"/><w:tblW w:w=\"0\" w:type=\"auto\"/><w:tblInd w:w=\"250\" w:type=\"dxa\" /><w:tblLook w:val=\"04A0\" w:firstRow=\"1\" w:lastRow=\"0\" w:firstColumn=\"1\" w:lastColumn=\"0\" w:noHBand=\"0\" w:noVBand=\"1\" /></w:tblPr>";
        TblPr tblPr = null;
        try {
            tblPr = (TblPr)XmlUtils.unmarshalString((String)strTblPr);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        tbl.setTblPr(tblPr);
        this.createTc(tbl, 0, 0, Messages.FirstPage_37);
        this.createTc(tbl, 0, 1, this.function.getCustomerManager());
        this.createTc(tbl, 1, 0, Messages.FirstPage_38);
        this.createTc(tbl, 1, 1, this.function.getDept());
        this.createTc(tbl, 2, 0, Messages.FirstPage_39);
        this.createTc(tbl, 2, 1, this.function.getHandManager());
        mdp.addObject((Object)tbl);
        mdp.addStyledParagraphOfText("Docinfo", "");
    }

    protected void createTc(Tbl tbl, int row, int cols, String content) {
        Tc tc = (Tc)((Tr)tbl.getContent().get(row)).getContent().get(cols);
        tc.getContent().clear();
        tc.getContent().add(this.wordMLPackage.getMainDocumentPart().createStyledParagraphOfText("DocInfoTable", content));
    }
}

