/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.fsd;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.meta.docx4j.docx.util.Docx4jUtil;
import aurora.ide.meta.gef.util.PathUtil;
import aurora.ide.prototype.consultant.product.fsd.ContextPage;
import aurora.ide.prototype.consultant.product.fsd.FSDDocumentPackage;
import aurora.ide.prototype.consultant.product.fsd.FirstPage;
import aurora.ide.prototype.consultant.product.fsd.FunctionDesc;
import aurora.ide.prototype.consultant.product.fsd.FunctionFSDPackage;
import aurora.ide.prototype.consultant.product.fsd.Messages;
import aurora.ide.prototype.consultant.product.fsd.SecondPage;
import aurora.ide.swt.util.PageModel;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import uncertain.composite.CompositeMap;

public class ExportProjectFSDProgress
implements IRunnableWithProgress {
    private List<String> functions;
    private PageModel function;
    private String savePath;
    private boolean onlySaveLogic = false;

    public ExportProjectFSDProgress(String savePath, PageModel fun, List<String> functions) {
        this.savePath = savePath;
        this.function = fun;
        this.functions = functions;
    }

    public ExportProjectFSDProgress(String savePath, PageModel fun, List<String> functions, boolean onlySaveLogic) {
        this(savePath, fun, functions);
        this.onlySaveLogic = onlySaveLogic;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Export FSD", 150);
        List<FunctionDesc> functions = this.createFunctions();
        boolean save = true;
        try {
            try {
                monitor.setTaskName(Messages.ExportFSDProgress_1);
                FSDDocumentPackage pkg = new FSDDocumentPackage();
                monitor.worked(10);
                pkg.create();
                monitor.worked(30);
                FirstPage page1 = new FirstPage(pkg, FunctionDesc.create(this.function));
                page1.create();
                monitor.worked(10);
                Docx4jUtil.createNewPage(pkg.getMainDocumentPart());
                SecondPage page2 = new SecondPage(pkg);
                page2.create();
                monitor.worked(10);
                Docx4jUtil.createNewPage(pkg.getMainDocumentPart());
                ContextPage page3 = new ContextPage(pkg);
                page3.create();
                monitor.worked(10);
                for (FunctionDesc fdd : functions) {
                    List propertyValue = (List)fdd.getPropertyValue("fsd_table_input");
                    FunctionFSDPackage fff = new FunctionFSDPackage(pkg, fdd, propertyValue, this.onlySaveLogic);
                    fff.run(monitor);
                }
                if (save) {
                    String filename = this.savePath;
                    monitor.setTaskName(String.valueOf(Messages.ExportFSDProgress_3) + filename);
                    pkg.getWordMLPackage().save(new File(filename));
                    System.out.println("Saved " + filename);
                    monitor.done();
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<String> getFunctionFiles(CompositeMap map, String base) {
        CompositeMap fileschild = map.getChild("fsd_table_input");
        String code = fileschild == null ? "" : fileschild.getText();
        code = code == null ? "" : code;
        String[] split = code.split(",");
        ArrayList<String> ss = new ArrayList<String>();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null && !"".equals(s)) {
                ss.add(PathUtil.makeAbsolute((String)s, (String)base).toString());
            }
            ++n2;
        }
        return ss;
    }

    private List<FunctionDesc> createFunctions() {
        ArrayList<FunctionDesc> r = new ArrayList<FunctionDesc>();
        for (String ff : this.functions) {
            Path p = new Path(ff);
            File file = p.toFile();
            if (!file.exists()) continue;
            CompositeMap loadFile = CompositeMapUtil.loadFile((File)file);
            CompositeMap namechild = loadFile.getChild("fun_name");
            String name = namechild == null ? "" : namechild.getText();
            name = name == null ? "" : name;
            CompositeMap codechild = loadFile.getChild("fun_code");
            String code = codechild == null ? "" : codechild.getText();
            code = code == null ? "" : code;
            FunctionDesc create = FunctionDesc.create(this.function);
            create.setPropertyValue("fun_name", name);
            create.setPropertyValue("fun_code", code);
            create.setPropertyValue("fsd_table_input", this.getFunctionFiles(loadFile, p.removeLastSegments(1).toString()));
            r.add(create);
        }
        return r;
    }
}

