/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.fsd;

import aurora.ide.meta.docx4j.docx.util.Docx4jUtil;
import aurora.ide.prototype.consultant.product.fsd.ContextPage;
import aurora.ide.prototype.consultant.product.fsd.FSDDocumentPackage;
import aurora.ide.prototype.consultant.product.fsd.FirstPage;
import aurora.ide.prototype.consultant.product.fsd.FunctionDesc;
import aurora.ide.prototype.consultant.product.fsd.FunctionFSDPackage;
import aurora.ide.prototype.consultant.product.fsd.Messages;
import aurora.ide.prototype.consultant.product.fsd.SecondPage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class ExportFSDProgress
implements IRunnableWithProgress {
    private List<String> files;
    private FunctionDesc function;
    private String savePath;
    private boolean onlySaveLogic = false;

    public ExportFSDProgress(String savePath, FunctionDesc fun, List<String> files) {
        this.savePath = savePath;
        this.function = fun;
        this.files = files;
    }

    public ExportFSDProgress(String savePath, FunctionDesc fun, List<String> files, boolean onlySaveLogic) {
        this(savePath, fun, files);
        this.onlySaveLogic = onlySaveLogic;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Export FSD", 150);
        boolean save = true;
        try {
            try {
                monitor.setTaskName(Messages.ExportFSDProgress_1);
                FSDDocumentPackage pkg = new FSDDocumentPackage();
                monitor.worked(10);
                pkg.create();
                monitor.worked(30);
                FirstPage page1 = new FirstPage(pkg, this.function);
                page1.create();
                monitor.worked(10);
                Docx4jUtil.createNewPage(pkg.getMainDocumentPart());
                SecondPage page2 = new SecondPage(pkg);
                page2.create();
                monitor.worked(10);
                Docx4jUtil.createNewPage(pkg.getMainDocumentPart());
                ContextPage page3 = new ContextPage(pkg);
                page3.create();
                monitor.worked(10);
                FunctionFSDPackage fff = new FunctionFSDPackage(pkg, this.function, this.files, this.onlySaveLogic);
                fff.run(monitor);
                if (save) {
                    String filename = this.savePath;
                    monitor.setTaskName(String.valueOf(Messages.ExportFSDProgress_3) + filename);
                    pkg.getWordMLPackage().save(new File(filename));
                    System.out.println("Saved " + filename);
                    monitor.done();
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }
}

