/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.demonstrate;

import aurora.ide.meta.gef.editors.wizard.dialog.DemonstratingDialog;
import aurora.ide.prototype.consultant.product.demonstrate.UIPInput;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class DrillDownAdapter {
    private DemonstratingDialog demonstratingDialog;
    private ToolItem homeItem;
    private ToolItem backItem;
    private ToolItem forwardItem;
    private UIPInput curentInput;
    private File home;

    public DrillDownAdapter(DemonstratingDialog demonstratingDialog, File home) {
        this.demonstratingDialog = demonstratingDialog;
        this.home = home;
    }

    public void addNavigationActions(ToolBar textToolBar) {
        this.createActions(textToolBar);
        this.updateNavigationButtons();
    }

    public boolean canGoBack() {
        if (this.curentInput != null) {
            return this.curentInput.getPrevious() != null;
        }
        return false;
    }

    public boolean canGoHome() {
        return this.home != null;
    }

    public boolean canGoForward() {
        if (this.curentInput != null) {
            return this.curentInput.getNext() != null;
        }
        return false;
    }

    private void createActions(ToolBar textToolBar) {
        if (this.homeItem != null) {
            return;
        }
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.backItem = new ToolItem(textToolBar, 131072);
        this.backItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillDownAdapter.this.goBack();
            }
        });
        this.backItem.setToolTipText("Back");
        this.backItem.setImage(images.getImage("IMG_TOOL_BACK"));
        this.homeItem = new ToolItem(textToolBar, 131072);
        this.homeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillDownAdapter.this.goHome();
            }
        });
        this.homeItem.setToolTipText("Home");
        this.homeItem.setImage(WorkbenchImages.getImage((String)"IMG_ETOOL_HOME_NAV"));
        this.forwardItem = new ToolItem(textToolBar, 131072);
        this.forwardItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DrillDownAdapter.this.goForward();
            }
        });
        this.forwardItem.setToolTipText("Forward");
        this.forwardItem.setImage(images.getImage("IMG_TOOL_FORWARD"));
        this.updateNavigationButtons();
    }

    public void goBack() {
        if (this.curentInput != null && this.curentInput.getPrevious() != null) {
            UIPInput previous = this.curentInput.getPrevious();
            this.demonstratingDialog.setInput((Object)previous);
        }
        this.updateNavigationButtons();
    }

    public void goHome() {
        if (this.home != null) {
            this.demonstratingDialog.setInput((Object)this.home);
        }
        this.updateNavigationButtons();
    }

    public void goForward() {
        if (this.curentInput != null && this.curentInput.getNext() != null) {
            UIPInput next = this.curentInput.getNext();
            this.demonstratingDialog.setInput((Object)next);
        }
        this.updateNavigationButtons();
    }

    public void inputChanged(UIPInput input) {
        this.curentInput = input;
        this.updateNavigationButtons();
    }

    protected void updateNavigationButtons() {
        if (this.homeItem != null) {
            this.homeItem.setEnabled(this.canGoHome());
            this.backItem.setEnabled(this.canGoBack());
            this.forwardItem.setEnabled(this.canGoForward());
        }
    }
}

