/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.demonstrate;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.meta.gef.control.ConsultantDemonstratingComposite;
import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.parts.ExtAuroraPartFactory;
import aurora.ide.meta.gef.editors.wizard.dialog.DemonstratingDialog;
import aurora.ide.prototype.consultant.product.demonstrate.DrillDownAdapter;
import aurora.ide.prototype.consultant.product.demonstrate.Messages;
import aurora.ide.prototype.consultant.product.demonstrate.UIPInput;
import aurora.ide.prototype.consultant.product.fsd.wizard.TitleControl;
import aurora.ide.prototype.consultant.view.Node;
import aurora.ide.prototype.consultant.view.property.page.ProjectDemonstratePropertyPage;
import aurora.ide.prototype.consultant.view.util.ResourceUtil;
import aurora.ide.swt.util.PageModel;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.io.CompositeMap2Object;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import uncertain.composite.CompositeMap;

public class DemonstratingMainPageDialog
extends DemonstratingDialog {
    private DemonstratingDialog demonstratingDialog;
    private Shell parentShell;
    private ConsultantDemonstratingComposite vsEditor;
    private PageModel model;
    private File activeFile;
    private DrillDownAdapter drillDown;
    private UIPInput curentInput;

    public DemonstratingMainPageDialog(Shell parentShell) {
        super(parentShell, null);
        this.parentShell = parentShell;
    }

    protected Point getInitialSize() {
        Rectangle bounds = Display.getCurrent().getBounds();
        return new Point(bounds.width, bounds.height);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.loadModel();
        this.drillDown = new DrillDownAdapter(this, this.getWelcomUip());
        Composite container = (Composite)this.innerCreateDialogArea(parent);
        container.setLayout((Layout)new GridLayout());
        ToolBar textToolBar = new ToolBar(container, 8390976);
        textToolBar.setLayoutData((Object)new GridData(768));
        this.drillDown.addNavigationActions(textToolBar);
        this.createFunctionMenu(textToolBar);
        this.vsEditor = new ConsultantDemonstratingComposite((DemonstratingDialog)this);
        this.vsEditor.createPartControl(container);
        this.vsEditor.getControl().setLayoutData((Object)new GridData(1808));
        this.vsEditor.setFocus();
        this.goWelcome();
        return container;
    }

    public void goWelcome() {
        this.openFile(this.getWelcomUip());
    }

    protected void openFile(File f) {
        this.openFile(new UIPInput(this.curentInput, (IPath)new Path(f.getPath())));
    }

    protected void openFile(UIPInput input) {
        this.curentInput = input;
        this.activeFile = input.getPath().toFile();
        this.drillDown.inputChanged(input);
        this.vsEditor.setInput(DemonstratingMainPageDialog.loadXML(this.activeFile));
    }

    private void loadModel() {
        ProjectDemonstratePropertyPage ppd = new ProjectDemonstratePropertyPage();
        ppd.setElement((IAdaptable)new Node(this.getProject()));
        this.model = ppd.getModel();
    }

    private File getWelcomUip() {
        String pp = this.model.getStringPropertyValue("welcome_uip");
        Path p = new Path(pp);
        File file = p.toFile();
        return file;
    }

    private String loadFuncitonName(ProjectDemonstratePropertyPage.F f) {
        File file = new File(f.functionPath);
        if (file.isFile()) {
            CompositeMap loadFile = CompositeMapUtil.loadFile((File)file);
            PageModel mm = new PageModel();
            TitleControl tc = new TitleControl(mm);
            tc.loadFromMap(loadFile);
            return mm.getStringPropertyValue("fun_name");
        }
        return "NONE_NAME";
    }

    private Menu createMenu(ProjectDemonstratePropertyPage.F f) {
        Menu menu = new Menu((Decorations)this.parentShell, 8);
        List<Object> uipFiles = f.uipFiles;
        for (Object o : uipFiles) {
            if (!(o instanceof String)) continue;
            MenuItem item = new MenuItem(menu, 0);
            Path p = new Path((String)o);
            String fileName = p.removeFileExtension().lastSegment();
            item.setText(fileName);
            item.addSelectionListener((SelectionListener)new SelectionAdapter((IPath)p){
                private final /* synthetic */ IPath val$p;
                {
                    this.val$p = iPath;
                }

                public void widgetSelected(SelectionEvent event) {
                    File file = this.val$p.toFile();
                    if (file.isFile()) {
                        DemonstratingMainPageDialog.this.openFile(file);
                    } else {
                        MessageDialog.openError((Shell)DemonstratingMainPageDialog.this.parentShell, (String)"ERROR", (String)(String.valueOf(Messages.DemonstratingMainPageDialog_2) + this.val$p.toString() + Messages.DemonstratingMainPageDialog_3));
                    }
                }
            });
        }
        return menu;
    }

    private String getMenuName(Node node) {
        File file;
        boolean module = ResourceUtil.isModule(node.getFile());
        if (module) {
            return node.getFile().getName();
        }
        boolean function = ResourceUtil.isFunction(node.getFile());
        if (function && (file = new File(node.getPropertiesPath())).isFile()) {
            CompositeMap loadFile = CompositeMapUtil.loadFile((File)file);
            PageModel mm = new PageModel();
            TitleControl tc = new TitleControl(mm);
            tc.loadFromMap(loadFile);
            return mm.getStringPropertyValue("fun_name");
        }
        return "NONE_NAME";
    }

    protected void createFunctionMenu(ToolBar textToolBar) {
        Node root = (Node)((Object)this.model.getPropertyValue("Root_Menu"));
        List<Node> children = root.getChildren();
        for (Node node : children) {
            if (!node.isChecked()) continue;
            ToolItem item = new ToolItem(textToolBar, 4);
            String menuName = this.getMenuName(node);
            item.setText(menuName);
            item.setToolTipText(menuName);
            item.setData((Object)node);
            Menu menu = this.createMenu(node);
            item.addSelectionListener((SelectionListener)new DropDownSelectionListener(menu));
        }
    }

    private void fillMenu(Menu menu, Node node) {
        List<Node> children = node.getChildren();
        for (Node n : children) {
            if (!n.isChecked()) continue;
            if (n.hasChildren()) {
                MenuItem subMenu = new MenuItem(menu, 64);
                subMenu.setText(this.getMenuName(n));
                Menu menu_1 = new Menu(subMenu);
                subMenu.setMenu(menu_1);
                this.fillMenu(menu_1, n);
                continue;
            }
            MenuItem item = new MenuItem(menu, 0);
            final IPath p = n.getPath();
            String fileName = p.removeFileExtension().lastSegment();
            item.setText(fileName);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    File file = p.toFile();
                    if (file.isFile()) {
                        DemonstratingMainPageDialog.this.openFile(file);
                    } else {
                        MessageDialog.openError((Shell)DemonstratingMainPageDialog.this.parentShell, (String)"ERROR", (String)(String.valueOf(Messages.DemonstratingMainPageDialog_2) + p.toString() + Messages.DemonstratingMainPageDialog_3));
                    }
                }
            });
        }
    }

    private Menu createMenu(Node node) {
        Menu menu = new Menu((Decorations)this.parentShell, 8);
        this.fillMenu(menu, node);
        return menu;
    }

    protected Control innerCreateDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        DemonstratingMainPageDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void setInput(Object input) {
        if (input instanceof File) {
            this.openFile((File)input);
        }
        if (input instanceof UIPInput) {
            this.openFile((UIPInput)input);
        }
    }

    private static ScreenBody loadXML(File file) {
        InputStream is = null;
        try {
            CompositeMap loadFile = CompositeMapUtil.loadFile((File)file);
            if (loadFile != null) {
                CompositeMap2Object c2o = new CompositeMap2Object();
                ScreenBody screenBody = c2o.createScreenBody(loadFile);
                return screenBody;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ScreenBody();
    }

    public void applyValue(String value) {
        this.close();
    }

    public IPath getActiveFilePath() {
        if (this.activeFile != null && this.activeFile.isFile()) {
            return new Path(this.activeFile.getPath());
        }
        return new Path("");
    }

    public boolean close() {
        boolean close = super.close();
        if (this.demonstratingDialog != null) {
            this.demonstratingDialog.close();
        }
        return close;
    }

    public EditPartFactory getPartFactory(EditorMode editorMode) {
        return new ExtAuroraPartFactory(editorMode);
    }

    public void setLoginPage(DemonstratingDialog demonstratingDialog) {
        this.demonstratingDialog = demonstratingDialog;
    }

    class DropDownSelectionListener
    extends SelectionAdapter {
        private Menu menu = null;

        public DropDownSelectionListener(Menu menu) {
            this.menu = menu;
        }

        public void widgetSelected(SelectionEvent event) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar toolBar = toolItem.getParent();
            Rectangle rect = toolItem.getBounds();
            Point pt = new Point(rect.x, rect.y + rect.height + 3);
            Point point = toolBar.toDisplay(pt);
            this.menu.setLocation(point.x, point.y);
            this.menu.setVisible(true);
        }
    }
}

