/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.demonstrate;

import aurora.ide.meta.gef.editors.models.commands.ChangePropertyCommand;
import aurora.ide.prototype.consultant.product.demonstrate.DemonstrateDSWizard;
import aurora.ide.prototype.consultant.product.demonstrate.DemonstrateLOVWizard;
import aurora.ide.prototype.consultant.product.demonstrate.DemonstrateOpeningWizard;
import aurora.ide.prototype.consultant.product.demonstrate.Messages;
import aurora.ide.swt.util.UWizard;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.DemonstrateBind;
import aurora.plugin.source.gen.screen.model.DemonstrateDS;
import aurora.plugin.source.gen.screen.model.DemonstrateData;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.io.CompositeMap2Object;
import aurora.plugin.source.gen.screen.model.io.Object2CompositeMap;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.swt.widgets.Shell;
import uncertain.composite.CompositeMap;

public class DemonstrateSettingManager {
    private AuroraComponent ac;
    private CommandStack commandStack;
    static final String s = String.valueOf(Messages.DemonstrateSettingManager_4) + "\n" + Messages.DemonstrateSettingManager_6 + "\n" + Messages.DemonstrateSettingManager_8 + "\n" + Messages.DemonstrateSettingManager_10;

    public DemonstrateSettingManager(AuroraComponent ac) {
        this.ac = ac;
    }

    public int openSettingWizard(Shell shell) {
        UWizard wd = this.createWizard(shell);
        int open = wd.open();
        return open;
    }

    private UWizard createWizard(Shell shell) {
        String componentType = this.ac.getComponentType();
        if ("gridcolumn".equals(componentType)) {
            GridColumn gc = (GridColumn)this.ac;
            if ("comboBox".equals(gc.getEditor())) {
                return new DemonstrateDSWizard(shell, this);
            }
            if ("lov".equals(gc.getEditor())) {
                return new DemonstrateLOVWizard(shell, this);
            }
        }
        if ("toolbar_button".equals(componentType) || "button".equals(componentType) || "gridcolumn".equals(componentType)) {
            return new DemonstrateOpeningWizard(shell, this);
        }
        if ("lov".equals(componentType)) {
            return new DemonstrateLOVWizard(shell, this);
        }
        if ("comboBox".equals(componentType)) {
            return new DemonstrateDSWizard(shell, this);
        }
        return new DemonstrateDSWizard(shell, this);
    }

    public boolean isWillDemonstrate() {
        String ct = this.ac.getComponentType();
        return "toolbar_button".equals(ct) || "button".equals(ct) || "gridcolumn".equals(ct) || "lov".equals(ct) || "comboBox".equals(ct);
    }

    public DemonstrateData getDemonstrateData() {
        Object propertyValue = this.ac.getPropertyValue("demonstrate_data");
        if (propertyValue instanceof DemonstrateData) {
            AuroraComponent cloneObject = this.cloneObject((AuroraComponent)propertyValue);
            List inputs = (List)((AuroraComponent)propertyValue).getPropertyValue("bind_component");
            List cloneInputs = (List)cloneObject.getPropertyValue("bind_component");
            if (inputs != null) {
                int i = 0;
                while (i < inputs.size()) {
                    DemonstrateBind demonstrateBind = (DemonstrateBind)inputs.get(i);
                    AuroraComponent bindModel = demonstrateBind.getBindModel();
                    if (bindModel != null) {
                        ((DemonstrateBind)cloneInputs.get(i)).setBindModel(bindModel);
                    }
                    ++i;
                }
            }
            return (DemonstrateData)cloneObject;
        }
        return this.getDefaultData();
    }

    private DemonstrateData getDefaultData() {
        DemonstrateDS ds;
        DemonstrateData demonstrateData = new DemonstrateData();
        String ct = this.ac.getComponentType();
        if ("lov".equals(ct)) {
            ds = DemonstrateSettingManager.lovDemonstrateDS();
            demonstrateData.setDemonstrateData(ds.getData());
            demonstrateData.setDemonstrateDSName("");
        }
        if ("comboBox".equals(ct)) {
            ds = DemonstrateSettingManager.comboxDemonstrateDS();
            demonstrateData.setDemonstrateData(ds.getData());
            demonstrateData.setDemonstrateDSName("");
        }
        return demonstrateData;
    }

    private AuroraComponent cloneObject(AuroraComponent ac) {
        Object2CompositeMap o2c = new Object2CompositeMap();
        CompositeMap map = o2c.createCompositeMap(ac);
        CompositeMap2Object c2o = new CompositeMap2Object();
        AuroraComponent createObject = c2o.createObject(map);
        return createObject;
    }

    public static DemonstrateDS comboxDemonstrateDS() {
        DemonstrateDS dds = new DemonstrateDS(Messages.DemonstrateSettingManager_0, Messages.DemonstrateSettingManager_1);
        return dds;
    }

    public static DemonstrateDS lovDemonstrateDS() {
        DemonstrateDS dds = new DemonstrateDS(Messages.DemonstrateSettingManager_11, s);
        return dds;
    }

    public void applyDemonData(DemonstrateData data) {
        ChangePropertyCommand command = new ChangePropertyCommand(this.ac, "demonstrate_data", (Object)data);
        if (this.commandStack != null) {
            this.getCommandStack().execute((Command)command);
        }
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public void setCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public AuroraComponent getAuroraComponent() {
        return this.ac;
    }
}

