/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.product.action;

import aurora.ide.editor.editorInput.PathEditorInput;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

public class RedoActionDelegate
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public RedoActionDelegate() {
        this.setEnabled(true);
    }

    public RedoActionDelegate(IWorkbenchWindow window, String label) {
        this.fWindow = window;
        this.setText(label);
        ISharedImages sharedImages = window.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO_DISABLED"));
        this.setToolTipText(label);
        this.setId("aurora.ide.prototype.consultant.product.action.RedoActionDelegate");
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private File queryFile() {
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4096);
        dialog.setText("Open File");
        dialog.setFilterExtensions(new String[]{"*.uip"});
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    public void run() {
        File file = this.queryFile();
        if (file != null) {
            IEditorInput input = this.createEditorInput(file);
            String editorId = this.getEditorId(file);
            IWorkbenchPage page = this.fWindow.getActivePage();
            try {
                page.openEditor(input, editorId);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    private String getEditorId(File file) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "aurora.ide.meta.gef.editors.ConsultantVScreenEditor";
    }

    private IEditorInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        PathEditorInput input = new PathEditorInput((IPath)location);
        return input;
    }
}

