/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.components.figure;

import java.util.List;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class TreeLayoutManager
extends AbstractLayout {
    public static final int NODE_DEFUAULT_WIDTH = 150;
    public static final int NODE_DEFUAULT_HIGHT = 24;
    public static final int X_STEP = 15;
    public static final int Y_STEP = 24;
    public static final Point NODE_RELATIVE_LOCATION = new Point(15, 24);
    public static final Dimension NODE_DEFUAULT_SIZE = new Dimension(150, 24);
    public static final Dimension TREE_DEFUAULT_SIZE = new Dimension(200, 180);
    public static final Dimension ZERO_SIZE = new Dimension(0, 0);

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension result = TREE_DEFUAULT_SIZE.getCopy();
        List children = container.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = child.getPreferredSize();
            childSize.expand(child.getBounds().getLocation());
            result.union(childSize);
            ++i;
        }
        return result;
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
        IFigure parent = child.getParent();
        int childWidth = child.getSize().width;
        int childHeight = child.getSize().height;
        Dimension newSize = new Dimension(childWidth >= 200 ? childWidth + 30 : 200, childHeight >= 180 ? childHeight + 48 : 200);
        parent.setSize(newSize);
    }

    public void layout(IFigure container) {
        List trees = container.getChildren();
        for (IFigure treeNode : trees) {
            Rectangle bounds = treeNode.getBounds();
            Point location = NODE_RELATIVE_LOCATION.getCopy();
            Dimension size = bounds.getSize();
            if (size.equals(0, 0)) {
                treeNode.setSize(NODE_DEFUAULT_SIZE);
            }
            location.translate(container.getBounds().getLocation());
            treeNode.getBounds().setLocation(location);
        }
        container.repaint();
    }
}

