/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.components.figure;

import aurora.ide.meta.gef.editors.components.part.CustomTreeNodePart;
import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.CustomTreeContainerNode;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;

public class BackTreeLayout
extends BackLayout {
    private static final int D_WIDTH = 76;
    private static final int D_HIGHT = 20;
    private static final Insets TREE_PADDING = new Insets(20, 18, 0, 0);

    protected Dimension calculatePreferredSize(ComponentPart treeContainer) {
        Dimension rc = new Dimension();
        Dimension textExtents = FigureUtilities.getTextExtents((String)treeContainer.getComponent().getPrompt(), (Font)treeContainer.getFigure().getFont());
        return rc.setSize(76 + textExtents.width, 20);
    }

    private Rectangle getBounds(ComponentPart cp) {
        return this.toDraw2d(cp.getComponent().getBoundsCopy());
    }

    public Rectangle layout(ComponentPart treeContainer) {
        AuroraComponent component = treeContainer.getComponent();
        boolean isExpand = false;
        if (component instanceof CustomTreeContainerNode) {
            isExpand = ((CustomTreeContainerNode)component).isExpand();
        }
        List children = treeContainer.getChildren();
        if (treeContainer instanceof CustomTreeNodePart || children == null || children.size() == 0 || !isExpand) {
            this.hideChildren(treeContainer);
            Rectangle rc = new Rectangle();
            return rc.setSize(this.calculatePreferredSize(treeContainer));
        }
        Point location = treeContainer.getFigure().getBounds().getLocation();
        Point cl = location.setX(location.x + BackTreeLayout.TREE_PADDING.left);
        Dimension size = this.calculatePreferredSize(treeContainer);
        cl.setY(cl.y + BackTreeLayout.TREE_PADDING.top);
        for (Object object : children) {
            if (!(object instanceof ComponentPart)) continue;
            Rectangle layout = ((ComponentPart)object).layout();
            layout.setLocation(cl);
            this.applyToFigure((ComponentPart)object, layout);
            size.setWidth(Math.max(size.width, layout.width + BackTreeLayout.TREE_PADDING.left));
            cl.setY(cl.y + layout.height);
            size.expand(0, layout.height);
        }
        return this.getBounds(treeContainer).setSize(size);
    }

    private void hideChildren(ComponentPart treeContainer) {
        List children = treeContainer.getChildren();
        if (children != null) {
            for (Object object : children) {
                if (!(object instanceof ComponentPart)) continue;
                this.applyToFigure((ComponentPart)object, new Rectangle());
            }
        }
    }

    private int getTreeLevel(IFigure temp) {
        List children = temp.getChildren();
        int level = 0;
        int childLevel = 0;
        int i = 0;
        while (i < children.size()) {
            level = 1;
            IFigure child = (IFigure)children.get(i);
            int treeLevel = this.getTreeLevel(child);
            childLevel = childLevel >= treeLevel ? childLevel : treeLevel;
            ++i;
        }
        return level + childLevel;
    }
}

