/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.components.eidtpolicy;

import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.gef.editors.models.commands.ChangeTextStyleCommand;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.wizard.dialog.TextEditDialog;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.LocationRequest;

public class TextStyleSupport {
    private ComponentPart part;
    private String property;

    public TextStyleSupport(ComponentPart part, String property) {
        this.part = part;
        this.property = property;
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType()) && req instanceof LocationRequest) {
            if (MetaPlugin.isDemonstrate) {
                return;
            }
            this.performEditStyledStringText(this.property);
        }
    }

    protected void performEditStyledStringText(String propertyID) {
        TextEditDialog ted = new TextEditDialog(this.part.getViewer().getControl().getShell());
        StyledStringText sst = new StyledStringText();
        Object obj = this.part.getComponent().getPropertyValue(String.valueOf(propertyID) + "_text_style");
        if (obj instanceof StyledStringText) {
            sst = (StyledStringText)obj;
        }
        sst.setText(this.part.getComponent().getStringPropertyValue(propertyID));
        ted.setStyledStringText(sst);
        if (ted.open() == 0) {
            sst = ted.getStyledStringText();
            ChangeTextStyleCommand command = new ChangeTextStyleCommand(this.part.getComponent(), propertyID, (Object)sst.getText(), sst);
            this.part.getViewer().getEditDomain().getCommandStack().execute((Command)command);
        }
    }
}

