/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors;

import aurora.ide.editor.editorInput.PathEditorInput;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.meta.gef.editors.BMViewer;
import aurora.ide.meta.gef.editors.ConsultantContextMenuProvider;
import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.FlayoutBMGEFEditor;
import aurora.ide.meta.gef.editors.Messages;
import aurora.ide.meta.gef.editors.VScreenEditorExtPaletteFactory;
import aurora.ide.meta.gef.editors.consultant.property.ConsultantPropertyManager;
import aurora.ide.meta.gef.editors.dnd.BMTransferDropTargetListener;
import aurora.ide.meta.gef.editors.parts.ExtAuroraPartFactory;
import aurora.ide.meta.gef.editors.property.MetaPropertyViewer;
import aurora.ide.meta.gef.editors.property.PropertyManager;
import aurora.ide.prototype.consultant.product.action.DemonstrateAction;
import aurora.ide.prototype.consultant.product.action.DemonstrateSettingAction;
import aurora.ide.prototype.consultant.product.action.FSDPropertyEditAction;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.io.CompositeMap2Object;
import aurora.plugin.source.gen.screen.model.io.Object2CompositeMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import uncertain.composite.CompositeMap;
import uncertain.composite.XMLOutputter;

public class ConsultantVScreenEditor
extends FlayoutBMGEFEditor {
    public static final String CONSULTANTVSCREENEDITOR_SAVE_NEW_FILE = "CONSULTANTVSCREENEDITOR_SAVE_NEW_FILE";
    public static final String CONTEXT_MENU_KEY = "aurora.ide.meta.gef.editor.contextmenu";
    ScreenBody diagram;
    private PaletteRoot root;
    private MetaPropertyViewer propertyViewer;
    private BMViewer bmViewer;
    private EditorMode editorMode = new EditorMode(){

        public String getMode() {
            return "None";
        }

        public boolean isForDisplay() {
            return false;
        }

        public boolean isForCreate() {
            return true;
        }

        public boolean isForUpdate() {
            return true;
        }

        public boolean isForSearch() {
            return false;
        }
    };
    private IEditorInput input;

    public void setFocus() {
        super.setFocus();
    }

    protected void updateActions(List actionIds) {
        super.updateActions(actionIds);
    }

    public ConsultantVScreenEditor() {
        this.getPalettePreferences().setPaletteState(4);
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof PathEditorInput) {
            boolean isSaveNew;
            IPath path;
            block7: {
                PathEditorInput pei = (PathEditorInput)editorInput;
                path = pei.getPath();
                isSaveNew = false;
                if (this.isUntitled()) {
                    FileDialog sd = new FileDialog(this.getSite().getShell(), 8192);
                    sd.setFileName(path.toString());
                    sd.setFilterExtensions(new String[]{"*.uip"});
                    sd.setOverwrite(true);
                    String open = sd.open();
                    if (open == null || open.length() < 1) {
                        return;
                    }
                    isSaveNew = true;
                    path = this.setNewPath(pei, open);
                }
                File file = path.toFile();
                try {
                    file.createNewFile();
                    if (file.exists() && file.canWrite()) {
                        Object2CompositeMap o2c = new Object2CompositeMap();
                        CompositeMap map = o2c.createCompositeMap(this.diagram);
                        XMLOutputter.saveToFile((File)file, (CompositeMap)map);
                        this.getCommandStack().markSaveLocation();
                    }
                }
                catch (IOException iOException) {
                    if (file.exists()) break block7;
                    MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"Info", (String)Messages.ConsultantVScreenEditor_2);
                }
            }
            if (isSaveNew) {
                isSaveNew = false;
                this.firePartPropertyChanged(CONSULTANTVSCREENEDITOR_SAVE_NEW_FILE, "", path.toOSString());
            }
        }
    }

    public IPath setNewPath(PathEditorInput pei, String open) {
        Path path = new Path(open);
        pei.setPath((IPath)path);
        String lastSegment = path.removeFileExtension().lastSegment();
        this.setPartName(lastSegment);
        return path;
    }

    public void doSaveAs() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof PathEditorInput) {
            PathEditorInput pei = (PathEditorInput)editorInput;
            IPath path = pei.getPath();
            FileDialog sd = new FileDialog(this.getSite().getShell(), 8192);
            sd.setFileName(".uip");
            sd.setFilterExtensions(new String[]{"*.uip"});
            sd.setOverwrite(true);
            String open = sd.open();
            if (open == null || open.length() < 1) {
                return;
            }
            path = this.setNewPath(pei, open);
            this.doSave(null);
            this.firePartPropertyChanged(CONSULTANTVSCREENEDITOR_SAVE_NEW_FILE, "", path.toOSString());
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setInput(IEditorInput input) {
        this.input = input;
        super.setInput(input);
        if (input instanceof PathEditorInput) {
            if (this.isUntitled()) {
                this.diagram = new ScreenBody();
            } else {
                File file = ((PathEditorInput)input).getPath().toFile();
                CompositeMap loadFile = CompositeMapUtil.loadFile((File)file);
                if (loadFile != null) {
                    CompositeMap2Object c2o = new CompositeMap2Object();
                    this.diagram = c2o.createScreenBody(loadFile);
                } else {
                    this.diagram = new ScreenBody();
                }
            }
            String lastSegment = ((PathEditorInput)input).getPath().removeFileExtension().lastSegment();
            this.setPartName(lastSegment);
            DefaultEditDomain defaultEditDomain = new DefaultEditDomain((IEditorPart)this);
            this.setEditDomain(defaultEditDomain);
        }
    }

    protected void createBMViewer(Composite c) {
    }

    public boolean isUntitled() {
        if (this.input instanceof PathEditorInput) {
            return ((PathEditorInput)this.input).isUntitled();
        }
        return false;
    }

    public void setDiagram(ScreenBody diagram) {
        this.diagram = diagram;
        GraphicalViewer gv = this.getGraphicalViewer();
        gv.setContents((Object)diagram);
        if (this.bmViewer != null) {
            this.bmViewer.refreshInput();
        }
        this.markDirty();
    }

    protected void createActions() {
        super.createActions();
        IAction action = this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
        action.setText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_4);
        action.setToolTipText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_5);
        action = this.getActionRegistry().getAction((Object)ActionFactory.PASTE.getId());
        action.setText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_6);
        action.setToolTipText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_7);
        action = this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId());
        action.setText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_8);
        action.setToolTipText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_9);
        action = this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId());
        action.setText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_10);
        action.setToolTipText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_11);
        action = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId());
        action.setText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_12);
        action.setToolTipText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_13);
        action = this.getActionRegistry().getAction((Object)"aurora.ide.meta.gef.editors.actions.CopyAsImageAction");
        action.setText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_14);
        action.setToolTipText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_14);
        action = this.getActionRegistry().getAction((Object)"aurora.ide.meta.gef.editors.actions.SaveAsImageAction");
        action.setText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_17);
        action.setToolTipText(aurora.ide.meta.gef.i18n.Messages.ConsultantVScreenEditor_17);
        FSDPropertyEditAction copyIMG = new FSDPropertyEditAction((GraphicalEditor)this);
        this.getActionRegistry().registerAction((IAction)copyIMG);
        this.getSelectionActions().add(copyIMG.getId());
        DemonstrateSettingAction dsa = new DemonstrateSettingAction((GraphicalEditor)this);
        this.getActionRegistry().registerAction((IAction)dsa);
        this.getSelectionActions().add(dsa.getId());
    }

    public void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new ScalableRootEditPart());
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new ExtAuroraPartFactory(this.editorMode));
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        ConsultantContextMenuProvider provider = new ConsultantContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(CONTEXT_MENU_KEY, (MenuManager)provider, (ISelectionProvider)this.getGraphicalViewer());
        this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)this.propertyViewer);
        if (DemonstrateAction.getIsDemon()) {
            this.maxEditorComposite();
        }
    }

    public void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.diagram);
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new BMTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = VScreenEditorExtPaletteFactory.createPalette((EditorMode)this.editorMode);
        }
        return this.root;
    }

    protected void createPropertyViewer(Composite c) {
        this.propertyViewer = new MetaPropertyViewer(c, (IWorkbenchPart)this, (PropertyManager)this.getPropertyManager());
    }

    public ConsultantPropertyManager getPropertyManager() {
        return new ConsultantPropertyManager(this.getEditDomain().getCommandStack());
    }

    public ScreenBody getDiagram() {
        return this.diagram;
    }
}

