/*
 * Decompiled with CFR 0.152.
 */
package aurora.javascript;

import aurora.javascript.Context;
import aurora.javascript.ContextFactory;
import aurora.javascript.InterfaceAdapter;
import aurora.javascript.Kit;
import aurora.javascript.Scriptable;
import aurora.javascript.Wrapper;
import java.lang.reflect.Member;
import java.util.Iterator;

public abstract class VMBridge {
    static final VMBridge instance = VMBridge.makeInstance();

    private static VMBridge makeInstance() {
        String[] classNames = new String[]{"aurora.javascript.VMBridge_custom", "aurora.javascript.jdk15.VMBridge_jdk15", "aurora.javascript.jdk13.VMBridge_jdk13", "aurora.javascript.jdk11.VMBridge_jdk11"};
        int i = 0;
        while (i != classNames.length) {
            VMBridge bridge;
            String className = classNames[i];
            Class<?> cl = Kit.classOrNull(className);
            if (cl != null && (bridge = (VMBridge)Kit.newInstanceOrNull(cl)) != null) {
                return bridge;
            }
            ++i;
        }
        throw new IllegalStateException("Failed to create VMBridge instance");
    }

    protected abstract Object getThreadContextHelper();

    protected abstract Context getContext(Object var1);

    protected abstract void setContext(Object var1, Context var2);

    protected abstract ClassLoader getCurrentThreadClassLoader();

    protected abstract boolean tryToMakeAccessible(Object var1);

    protected Object getInterfaceProxyHelper(ContextFactory cf, Class<?>[] interfaces) {
        throw Context.reportRuntimeError("VMBridge.getInterfaceProxyHelper is not supported");
    }

    protected Object newInterfaceProxy(Object proxyHelper, ContextFactory cf, InterfaceAdapter adapter, Object target, Scriptable topScope) {
        throw Context.reportRuntimeError("VMBridge.newInterfaceProxy is not supported");
    }

    protected abstract boolean isVarArgs(Member var1);

    public Iterator<?> getJavaIterator(Context cx, Scriptable scope, Object obj) {
        if (obj instanceof Wrapper) {
            Object unwrapped = ((Wrapper)obj).unwrap();
            Iterator iterator = null;
            if (unwrapped instanceof Iterator) {
                iterator = (Iterator)unwrapped;
            }
            return iterator;
        }
        return null;
    }
}

