/*
 * Decompiled with CFR 0.152.
 */
package aurora.javascript;

import aurora.javascript.Wrapper;
import java.util.Arrays;

class ResolvedOverload {
    final Class<?>[] types;
    final int index;

    ResolvedOverload(Object[] args, int index) {
        this.index = index;
        this.types = new Class[args.length];
        int i = 0;
        int l = args.length;
        while (i < l) {
            Object arg = args[i];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            this.types[i] = arg == null ? null : arg.getClass();
            ++i;
        }
    }

    boolean matches(Object[] args) {
        if (args.length != this.types.length) {
            return false;
        }
        int i = 0;
        int l = args.length;
        while (i < l) {
            Object arg = args[i];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg == null ? this.types[i] != null : arg.getClass() != this.types[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ResolvedOverload)) {
            return false;
        }
        ResolvedOverload ovl = (ResolvedOverload)other;
        return Arrays.equals(this.types, ovl.types) && this.index == ovl.index;
    }

    public int hashCode() {
        return Arrays.hashCode(this.types);
    }
}

