/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.template;

import java.util.HashMap;
import java.util.Map;
import uncertain.util.template.DefaultTagCreator;
import uncertain.util.template.ITagCreator;
import uncertain.util.template.ITagCreatorRegistry;

public class TagCreatorRegistry
implements ITagCreatorRegistry {
    static final TagCreatorRegistry DEFAULT_INSTANCE = new TagCreatorRegistry();
    ITagCreatorRegistry mParent;
    Map mCreatorMap;
    ITagCreator mDefaultCreator = DefaultTagCreator.DEFAULT_INSTANCE;

    public static TagCreatorRegistry getInstance() {
        return DEFAULT_INSTANCE;
    }

    public TagCreatorRegistry() {
        this.mCreatorMap = new HashMap();
    }

    @Override
    public void setParent(ITagCreatorRegistry parent) {
        this.mParent = parent;
    }

    @Override
    public ITagCreator getTagCreator(String name_space) {
        if (name_space == null && this.mDefaultCreator != null) {
            return this.mDefaultCreator;
        }
        ITagCreator creator = (ITagCreator)this.mCreatorMap.get(name_space);
        if (creator != null) {
            return creator;
        }
        if (this.mParent != null) {
            return this.mParent.getTagCreator(name_space);
        }
        return null;
    }

    public ITagCreator getDefaultCreator() {
        if (this.mDefaultCreator != null) {
            return this.mDefaultCreator;
        }
        if (this.mParent != null) {
            return this.mParent.getTagCreator(null);
        }
        return null;
    }

    public void setDefaultCreator(ITagCreator creator) {
        this.mDefaultCreator = creator;
    }

    @Override
    public void registerTagCreator(String name_space, ITagCreator creator) {
        this.mCreatorMap.put(name_space, creator);
    }
}

