/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util;

public class XMLWritter {
    public static String DEFAULT_ENCODING = "utf-8";

    public static String getXMLDecl(String encoding) {
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        return "<?xml version=\"1.0\" encoding = \"" + encoding + "\"?>\r\n";
    }

    public static String startTag(String element) {
        return "<" + element + ">";
    }

    public static String endTag(String element) {
        return "</" + element + ">";
    }

    public static String cdata(String value) {
        return "<![CDATA[" + value + "]]>";
    }

    public static String getAttrib(String key, String value) {
        return String.valueOf(key) + '=' + '\"' + XMLWritter.escape(value) + '\"';
    }

    public static String escape(String value) {
        StringBuffer dom = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            if (ch == '<') {
                dom.append("&lt;");
            } else if (ch == '>') {
                dom.append("&gt;");
            } else if (ch == '&') {
                dom.append("&amp;");
            } else if (ch == '\"') {
                dom.append("&quot;");
            } else if (ch == '\'') {
                dom.append("&apos;");
            } else {
                dom.append(ch);
            }
            ++i;
        }
        return dom.toString();
    }
}

