/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import uncertain.util.TagParseHandle;

public class TagParser {
    TagParseHandle tag_handle;

    public TagParser(TagParseHandle th) {
        this.tag_handle = th;
    }

    public String parse(String str, char escape) {
        if (str == null) {
            return null;
        }
        try {
            return this.parse(new StringReader(str), escape);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String parse(Reader in, char escape) throws IOException {
        String vl;
        int ch;
        boolean in_escape = false;
        String var = "";
        StringBuffer buf = new StringBuffer();
        int index = 0;
        while ((ch = in.read()) != -1) {
            char chr = (char)ch;
            if (in_escape) {
                if (Character.isLetterOrDigit(chr) || ch == 95) {
                    var = String.valueOf(var) + chr;
                } else {
                    in_escape = false;
                    if (var.length() > 0) {
                        String vl2 = this.tag_handle.ProcessTag(index, var);
                        if (vl2 != null) {
                            buf.append(vl2);
                        }
                    } else if (chr == escape) {
                        buf.append(chr);
                        continue;
                    }
                    var = "";
                }
            }
            if (chr == escape) {
                in_escape = true;
            } else if (!in_escape) {
                buf.append(chr);
            }
            ++index;
        }
        if (in_escape && (vl = this.tag_handle.ProcessTag(index, var)) != null) {
            buf.append(vl);
        }
        return buf.toString();
    }

    public static String parse(Reader in, char escape, Map props) throws IOException {
        final Map p = props;
        return new TagParser(new TagParseHandle(){

            @Override
            public String ProcessTag(int index, String tag) {
                return (String)p.get(tag);
            }

            @Override
            public int ProcessCharacter(int index, char ch) {
                return ch;
            }
        }).parse(in, escape);
    }

    public static String parse(String text, char escape, Map props) {
        try {
            return TagParser.parse(new StringReader(text), escape, props);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

