/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.HashMap;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.core.ConfigurationError;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.ConfigurationFileException;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class Assert
extends AbstractEntry {
    public static final String UNCERTAIN_PROC_ASSERT_UNKNOWN_OPERATOR = "uncertain.proc.assert_unknown_operator";
    public static final int NULL = 0;
    public static final int NOTNULL = 1;
    public static final int EQUAL = 2;
    public static final int NOTEQUAL = 3;
    public static final int GREAT_THAN = 4;
    public static final int LESS_THAN = 5;
    public static final int GOE = 6;
    public static final int LOE = 7;
    static HashMap _operator_map = new HashMap();
    public String field;
    public String operator;
    public String value;
    public String message;

    static {
        _operator_map.put("null", new Integer(0));
        _operator_map.put("not null", new Integer(1));
        _operator_map.put("=", new Integer(2));
        _operator_map.put("==", new Integer(2));
        _operator_map.put("equal", new Integer(2));
        _operator_map.put("!=", new Integer(3));
        _operator_map.put("<>", new Integer(3));
        _operator_map.put(">", new Integer(4));
        _operator_map.put("<", new Integer(5));
        _operator_map.put(">=", new Integer(6));
        _operator_map.put("<=", new Integer(7));
    }

    public int operatorID(String op) {
        Integer id = (Integer)_operator_map.get(op.toLowerCase());
        return id == null ? -1 : id;
    }

    @Override
    public void run(ProcedureRunner runner) {
        if (this.field == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "field");
        }
        if (this.operator == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "operator");
        }
        int opid = this.operatorID(this.operator);
        if (opid < 0) {
            throw new ConfigurationFileException(UNCERTAIN_PROC_ASSERT_UNKNOWN_OPERATOR, new Object[]{this.operator}, this);
        }
        CompositeMap context = runner.getContext();
        Object test_field = context.getObject(this.field);
        block1 : switch (opid) {
            case 0: {
                if (test_field != null) {
                    throw new AssertionError((Object)(this.message == null ? "Field '" + this.field + "' is expected to be null" : this.message));
                }
                break;
            }
            case 1: {
                if (test_field == null) {
                    throw new AssertionError((Object)(this.message == null ? "Field '" + this.field + "' is expected to be not null" : this.message));
                }
                break;
            }
            case 2: 
            case 3: {
                if (this.value == null) {
                    throw new ConfigurationError("assert: 'value' property must be set");
                }
                this.value = TextParser.parse(this.value, context);
                if (opid == 2) {
                    if (!this.value.equals(test_field)) {
                        throw new AssertionError((Object)(this.message == null ? "Field '" + this.field + "' is expected to be " + this.value + ", but actual value is " + test_field : this.message));
                    }
                    break;
                }
                if (this.value.equals(test_field)) {
                    throw new AssertionError((Object)(this.message == null ? "Field '" + this.field + "' is not expected to be " + this.value : this.message));
                }
                break;
            }
            default: {
                if (this.value == null) {
                    throw BuiltinExceptionFactory.createAttributeMissing(this, "value");
                }
                String parsed_value = TextParser.parse(this.value, context);
                Double d_value = null;
                if (test_field == null) {
                    throw new AssertionError((Object)("Field '" + this.field + "' is null, can't be compared as number"));
                }
                try {
                    d_value = new Double(Double.parseDouble(parsed_value));
                }
                catch (NumberFormatException ex) {
                    throw BuiltinExceptionFactory.createValueNotNumberException(this, parsed_value);
                }
                Number d_test_field = null;
                if (test_field instanceof String) {
                    d_test_field = new Double(Double.parseDouble((String)test_field));
                } else if (test_field instanceof Number) {
                    d_test_field = (Number)test_field;
                } else {
                    throw new AssertionError((Object)("Field '" + this.field + "' is not a number"));
                }
                switch (opid) {
                    case 4: {
                        if (d_test_field.doubleValue() <= d_value) {
                            throw new AssertionError((Object)(this.message == null ? "Field '" + this.field + "' is expected to be >" + this.value + ", but actual value is " + test_field : this.message));
                        }
                        break block1;
                    }
                    case 5: {
                        if (d_test_field.doubleValue() >= d_value) {
                            throw new AssertionError((Object)(this.message == null ? "Field '" + this.field + "' is expected to be <" + this.value + ", but actual value is " + test_field : this.message));
                        }
                        break block1;
                    }
                    case 6: {
                        if (d_test_field.doubleValue() < d_value) {
                            throw new AssertionError((Object)(this.message == null ? "Field '" + this.field + "' is expected to be >=" + this.value + ", but actual value is " + test_field : this.message));
                        }
                        break block1;
                    }
                    case 7: {
                        if (d_test_field.doubleValue() > d_value) {
                            throw new AssertionError((Object)(this.message == null ? "Field '" + this.field + "' is expected to be <=" + this.value + ", but actual value is " + test_field : this.message));
                        }
                        break block1;
                    }
                }
            }
        }
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

