/*
 * Decompiled with CFR 0.152.
 */
package uncertain.mbean;

import java.lang.reflect.Method;
import uncertain.mbean.IMBeanRegister;
import uncertain.mbean.RegisterJDK15;

public class MBeanRegister {
    static Class[] ARG_TYPES = new Class[]{String.class, Object.class};
    static Method REGISTER_METHOD = null;

    static {
        int v = MBeanRegister.getJDKVersion();
        String cls = String.valueOf(MBeanRegister.class.getPackage().getName()) + ".RegisterJDK";
        cls = v > 4 ? String.valueOf(cls) + "15" : String.valueOf(cls) + "14";
        try {
            Class<?> regcls = Class.forName(cls);
            REGISTER_METHOD = regcls.getMethod("register", ARG_TYPES);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static IMBeanRegister getInstance() {
        return RegisterJDK15.getInstance();
    }

    public static String getDefaultMBeanName(String domain, String type, String name) {
        return "org.uncertain." + domain + ":type=" + type + ",name=" + name;
    }

    public static String getDefaultMBeanName(String type, String name) {
        return "org.uncertain:type=" + type + ",name=" + name;
    }

    public static void resiterMBean(String name, Object obj) {
        if (REGISTER_METHOD != null) {
            Object[] args = new Object[]{name, obj};
            try {
                REGISTER_METHOD.invoke(null, args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static int getJDKVersion() {
        String s = System.getProperty("java.version");
        String[] array = s.split("\\.");
        if (array.length > 1) {
            return Integer.parseInt(array[1]);
        }
        return 0;
    }
}

