/*
 * Decompiled with CFR 0.152.
 */
package uncertain.event;

import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.event.Configuration;
import uncertain.event.IRuntimeContext;
import uncertain.proc.trace.StackTraceManager;

public class RuntimeContext
extends DynamicObject
implements IRuntimeContext {
    public static final String KEY_CONFIGURATION = "__configuration__";
    public static final String KEY_LAST_HANDLED_EXCEPTION = "__last_handled_exception__";
    public static final String KEY_EXCEPTION = "__exception__";
    public static final String KEY_IS_TRACE = "__is_trace__";
    public static final String KEY_SERVICE_SUCCESS = "__service_success__";

    public static RuntimeContext getInstance(CompositeMap map) {
        RuntimeContext context = new RuntimeContext();
        context.initialize(map);
        return context;
    }

    private CompositeMap getParentMap() {
        return this.getObjectContext().getParent();
    }

    public Configuration getConfig() {
        Configuration config = (Configuration)this.get(KEY_CONFIGURATION);
        if (config == null) {
            CompositeMap map = this.getParentMap();
            while (map != null) {
                config = (Configuration)map.get(KEY_CONFIGURATION);
                if (config != null) {
                    return config;
                }
                map = map.getParent();
            }
            return null;
        }
        return config;
    }

    public void setConfig(Configuration config) {
        this.put(KEY_CONFIGURATION, config);
    }

    public void fireEvent(String event_name, Object[] args) {
        Configuration config = this.getConfig();
        if (config == null) {
            return;
        }
        try {
            config.fireEvent(event_name, args);
        }
        catch (Throwable thr) {
            this.setException(thr);
        }
    }

    public void fireEvent(String event_name) {
        this.fireEvent(event_name, null);
    }

    public static String getTypeKey(Class type) {
        return "_instance." + type.getName();
    }

    public Object getInstanceOfType(Class type) {
        if (this.getObjectContext() == null) {
            throw new IllegalStateException("Object context not initialized");
        }
        Object obj = this.get(RuntimeContext.getTypeKey(type));
        if (obj == null && this.getParentMap() != null) {
            obj = this.getParentMap().get(RuntimeContext.getTypeKey(type));
        }
        return obj;
    }

    public void setInstanceOfType(Class type, Object instance) {
        this.put(RuntimeContext.getTypeKey(type), instance);
    }

    public Throwable getException() {
        return (Throwable)this.get(KEY_EXCEPTION);
    }

    public void setException(Throwable e) {
        this.put(KEY_EXCEPTION, e);
    }

    public Throwable getLastHandledException() {
        return (Throwable)this.get(KEY_LAST_HANDLED_EXCEPTION);
    }

    public void setLastHandledException(Throwable thr) {
        this.put(KEY_LAST_HANDLED_EXCEPTION, thr);
    }

    public boolean isTrace() {
        return this.getBoolean(KEY_IS_TRACE, false);
    }

    public void setTrace(boolean trace) {
        this.putBoolean(KEY_IS_TRACE, trace);
    }

    public boolean isSuccess() {
        return this.getBoolean(KEY_SERVICE_SUCCESS, true);
    }

    public void setSuccess(boolean success) {
        this.putBoolean(KEY_SERVICE_SUCCESS, success);
    }

    public StackTraceManager getStackTraceManager() {
        return (StackTraceManager)this.getInstanceOfType(StackTraceManager.class);
    }

    public void setStackTraceManager(StackTraceManager stm) {
        this.setInstanceOfType(StackTraceManager.class, stm);
    }
}

