/*
 * Decompiled with CFR 0.152.
 */
package uncertain.composite.transform;

import java.util.Iterator;
import java.util.LinkedHashMap;
import uncertain.composite.CompositeMap;
import uncertain.composite.transform.AbstractTransform;
import uncertain.composite.transform.Transformer;
import uncertain.composite.transform.TreeTransformer;
import uncertain.proc.ProcedureRunner;

public class TreeTransform
extends AbstractTransform {
    public static final String KEY_ID_FIELD = "idfield";
    public static final String KEY_PARENT_FIELD = "parentfield";
    final String KEY_SOURCE = "source";
    final String KEY_TARGET = "target";
    CompositeMap elementConifg;

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        String source = this.elementConifg.getString("source");
        assert (source != null);
        String target = this.elementConifg.getString("target");
        assert (target != null);
        CompositeMap context = runner.getContext();
        CompositeMap sourceMap = (CompositeMap)context.getObject(source);
        CompositeMap targetMap = (CompositeMap)sourceMap.clone();
        context.putObject(target, (Object)targetMap, true);
        this.transform(targetMap, this.elementConifg);
    }

    @Override
    public void beginConfigure(CompositeMap config) {
        this.elementConifg = config;
    }

    public static CompositeMap createTreeTransform(String id_field, String parent_id_field) {
        CompositeMap config = Transformer.createTransformConfig(TreeTransformer.class.getName());
        config.put(KEY_ID_FIELD, id_field);
        config.put(KEY_PARENT_FIELD, parent_id_field);
        return config;
    }

    public CompositeMap transform(CompositeMap source, CompositeMap transform_config) {
        CompositeMap item;
        if (source == null || transform_config == null) {
            return null;
        }
        Object id_field = transform_config.get(KEY_ID_FIELD);
        if (id_field == null) {
            throw new IllegalArgumentException("TreeTransformer:id-field must be set");
        }
        Object parent_field = transform_config.get(KEY_PARENT_FIELD);
        if (parent_field == null) {
            throw new IllegalArgumentException("TreeTransformer:parent-field must be set");
        }
        Iterator childs = source.getChildIterator();
        if (childs == null) {
            return source;
        }
        LinkedHashMap all_items = new LinkedHashMap((int)((double)source.getChilds().size() / 0.75));
        while (childs.hasNext()) {
            item = (CompositeMap)childs.next();
            item.setParent(null);
            Object id_value = item.get(id_field);
            all_items.put(id_value, item);
        }
        childs = source.getChildIterator();
        while (childs.hasNext()) {
            item = (CompositeMap)childs.next();
            Object parent_id_value = item.get(parent_field);
            CompositeMap parent = (CompositeMap)all_items.get(parent_id_value);
            if (parent == null) continue;
            parent.addChild(item);
        }
        source.getChilds().clear();
        for (CompositeMap item2 : all_items.values()) {
            if (item2.getParent() != null) continue;
            source.addChild(item2);
        }
        return source;
    }
}

