/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import uncertain.cache.ICache;
import uncertain.cache.ICacheClone;
import uncertain.cache.ITransactionCache;

public class TransactionCache
implements ITransactionCache {
    ICache mainCache;
    ICache assistCache;
    boolean isICacheClone = false;
    private ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock();
    private Lock writeLock = this.rwlock.writeLock();
    private Lock readLock = this.rwlock.readLock();
    private ReentrantLock trxLock = new ReentrantLock();

    public TransactionCache(ICache cache) {
        this.mainCache = cache;
        this.isICacheClone = this.isICacheClone(cache);
    }

    @Override
    public Object getValue(Object key) {
        this.readLock.lock();
        try {
            Object object = this.mainCache.getValue(key);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean setValue(Object key, Object value) {
        this.checkTrxStatus();
        this.assistCache.setValue(key, value);
        return true;
    }

    @Override
    public boolean setValue(Object key, int timeout, Object value) {
        this.checkTrxStatus();
        this.assistCache.setValue(key, timeout, value);
        return true;
    }

    @Override
    public void remove(Object key) {
        this.checkTrxStatus();
        this.assistCache.remove(key);
    }

    @Override
    public void clear() {
        this.checkTrxStatus();
        this.assistCache.clear();
    }

    @Override
    public void beginTransaction() {
        this.trxLock.lock();
        if (!this.isICacheClone) {
            this.assistCache = this.mainCache;
        } else {
            if (this.assistCache != null) {
                this.assistCache.clear();
            }
            this.assistCache = (ICache)((ICacheClone)((Object)this.mainCache)).cacheClone();
        }
    }

    @Override
    public void commit() {
        block6: {
            this.checkTrxStatus();
            try {
                if (!this.isICacheClone) break block6;
                this.writeLock.lock();
                try {
                    this.mainCache.clear();
                    ((ICacheClone)((Object)this.mainCache)).cacheCopy((ICacheClone)((Object)this.assistCache));
                }
                finally {
                    this.writeLock.unlock();
                }
                this.assistCache.clear();
                this.assistCache = null;
            }
            finally {
                this.trxLock.unlock();
            }
        }
    }

    @Override
    public void rollback() {
        this.checkTrxStatus();
        try {
            if (this.isICacheClone) {
                this.assistCache.clear();
                this.assistCache = null;
            }
        }
        finally {
            this.trxLock.unlock();
        }
    }

    private boolean checkTrxStatus() {
        if (!this.isICacheClone) {
            return true;
        }
        if (!this.trxLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("call beginTransaction first, and remeber call commit or rollback after.");
        }
        return true;
    }

    private boolean isICacheClone(ICache cache) {
        return cache instanceof ICacheClone;
    }
}

