/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uncertain.cache.ICache;
import uncertain.cache.ICacheClone;
import uncertain.cache.MapBasedCacheMBean;
import uncertain.mbean.MBeanUtil;

public class MapBasedCache
implements ICache,
MapBasedCacheMBean,
ICacheClone {
    public static final int DEFAULT_CACHE_SIZE = 1000;
    String mName;
    long mRequestCount = 0L;
    long mHitCount = 0L;
    long mUpdateCount = 0L;
    HashMap mCacheMap;
    Date mCreationDate = new Date();

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public MapBasedCache() {
        this.mCacheMap = new HashMap(1000);
    }

    public MapBasedCache(HashMap map) {
        this.mCacheMap = map;
    }

    public MapBasedCache(int capacity) {
        this.mCacheMap = new HashMap(capacity);
    }

    public MapBasedCache(int capacity, float load_factor) {
        this.mCacheMap = new HashMap(capacity, load_factor);
    }

    @Override
    public boolean setValue(Object key, Object value) {
        this.mCacheMap.put(key, value);
        ++this.mUpdateCount;
        return true;
    }

    @Override
    public boolean setValue(Object key, int timeout, Object value) {
        this.setValue(key, value);
        return true;
    }

    @Override
    public void remove(Object key) {
        this.mCacheMap.remove(key);
    }

    @Override
    public Object getValue(Object key) {
        ++this.mRequestCount;
        Object v = this.mCacheMap.get(key);
        if (v != null) {
            ++this.mHitCount;
        }
        return v;
    }

    @Override
    public void clear() {
        this.mCacheMap.clear();
        this.mHitCount = 0L;
        this.mUpdateCount = 0L;
    }

    @Override
    public long getRequestCount() {
        return this.mRequestCount;
    }

    @Override
    public long getHitCount() {
        return this.mHitCount;
    }

    @Override
    public float getHitRate() {
        return this.mRequestCount == 0L ? 0.0f : (float)this.mHitCount / (float)this.mRequestCount;
    }

    @Override
    public long getUpdateCount() {
        return this.mUpdateCount;
    }

    @Override
    public int getSize() {
        return this.mCacheMap.size();
    }

    @Override
    public Date getCreationDate() {
        return this.mCreationDate;
    }

    @Override
    public String dumpMappings() {
        return MBeanUtil.dumpMap(this.mCacheMap);
    }

    @Override
    public Object cacheClone() {
        return new MapBasedCache((HashMap)this.mCacheMap.clone());
    }

    @Override
    public Iterator iterator() {
        return this.mCacheMap.entrySet().iterator();
    }

    public Map getMap() {
        return this.mCacheMap;
    }

    @Override
    public void cacheCopy(ICacheClone cache) {
        if (cache instanceof MapBasedCache) {
            this.mCacheMap.putAll(((MapBasedCache)cache).getMap());
        } else {
            Iterator it = cache.iterator();
            if (it != null) {
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    this.mCacheMap.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

