/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sync.cvs;

import java.io.IOException;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class CVSClient {
    private Client cvsclient;
    private CVSRoot cvsroot;
    private Connection connection;

    public CVSClient(String connectionString) {
        this.cvsroot = CVSRoot.parse((String)connectionString);
        this.connection = ConnectionFactory.getConnection((CVSRoot)this.cvsroot);
        this.cvsclient = new Client(this.connection, (AdminHandler)new StandardAdminHandler());
    }

    public Connection openConnection() throws AuthenticationException, CommandAbortedException {
        this.connection.open();
        return this.connection;
    }

    public void closeConnection() throws IOException {
        this.connection.close();
    }

    public void excute(Command command) throws AuthenticationException, CommandAbortedException, IOException, CommandException {
        System.out.println("***Command***" + command.getCVSCommand());
        this.cvsclient.executeCommand(command, new GlobalOptions());
    }

    public void addCVSListener(CVSListener listener) {
        this.cvsclient.getEventManager().addCVSListener(listener);
    }
}

