/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sso.cas;

import aurora.application.action.HttpSessionCopy;
import aurora.application.features.HttpRequestTransfer;
import aurora.service.IService;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import aurora.service.ServiceThreadLocal;
import aurora.service.http.HttpServiceInstance;
import aurora.service.http.WebContextInit;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.util.AssertionHolder;
import uncertain.composite.CompositeMap;
import uncertain.core.IContainer;
import uncertain.event.Configuration;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class AutoSetUserFilter
implements Filter {
    public static final String PLUGIN = AutoSetUserFilter.class.getCanonicalName();
    public static final String AURORA_USER_LOGIN = "_aurora_user_login_";
    public static final String DEFAULT_LOGIN_PROC = "init.auto_login";
    private String afterLoginRedirectUrl;
    private String autoLoginProc;
    IObjectRegistry objectRegistry;
    ILogger logger;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.afterLoginRedirectUrl = this.getPropertyFromInitParams(filterConfig, "afterLoginRedirectUrl", null);
        this.autoLoginProc = this.getPropertyFromInitParams(filterConfig, "autoLoginProc", null);
        if (this.autoLoginProc == null) {
            this.autoLoginProc = DEFAULT_LOGIN_PROC;
        }
        this.objectRegistry = WebContextInit.getUncertainEngine((ServletContext)filterConfig.getServletContext()).getObjectRegistry();
        this.logger = LoggingContext.getLogger((String)PLUGIN, (IObjectRegistry)this.objectRegistry);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        Object user_login = session.getAttribute(AURORA_USER_LOGIN);
        if (user_login != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String loginName = AssertionHolder.getAssertion().getPrincipal().getName();
        try {
            this.executeLoginProc(request, response, loginName);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "executeLoginProc error:", (Throwable)e);
            return;
        }
        session.setAttribute(AURORA_USER_LOGIN, (Object)Boolean.TRUE);
        if (this.afterLoginRedirectUrl != null) {
            response.sendRedirect(this.afterLoginRedirectUrl);
        }
    }

    public void executeLoginProc(HttpServletRequest request, HttpServletResponse response, String loginName) throws Exception {
        IProcedureManager procedureManager = (IProcedureManager)this.objectRegistry.getInstanceOfType(IProcedureManager.class);
        IServiceFactory serviceFactory = (IServiceFactory)this.objectRegistry.getInstanceOfType(IServiceFactory.class);
        Procedure proc = procedureManager.loadProcedure(this.autoLoginProc);
        CompositeMap auroraContext = new CompositeMap("sso_conext");
        auroraContext.createChild("parameter").put((Object)"user_name", (Object)loginName);
        HttpServiceInstance svc = this.createHttpService(this.autoLoginProc, request, response, procedureManager, auroraContext);
        ServiceThreadLocal.setCurrentThreadContext((CompositeMap)auroraContext);
        ServiceInvoker.invokeProcedureWithTransaction((String)this.autoLoginProc, (Procedure)proc, (IServiceFactory)serviceFactory, (IService)svc, (CompositeMap)auroraContext);
        ServiceThreadLocal.setCurrentThreadContext((CompositeMap)auroraContext);
        HttpRequestTransfer.copyRequest((HttpServiceInstance)svc);
        HttpSessionCopy.copySession((CompositeMap)auroraContext, (HttpSession)request.getSession(false));
    }

    public HttpServiceInstance createHttpService(String service_name, HttpServletRequest request, HttpServletResponse response, IProcedureManager procedureManager, CompositeMap context) {
        HttpServiceInstance svc = new HttpServiceInstance(service_name, procedureManager);
        svc.setRequest(request);
        svc.setResponse(response);
        svc.setContextMap(context);
        svc.setName(service_name);
        HttpRequestTransfer.copyRequest((HttpServiceInstance)svc);
        HttpSessionCopy.copySession((CompositeMap)svc.getContextMap(), (HttpSession)request.getSession(false));
        IContainer container = (IContainer)this.objectRegistry.getInstanceOfType(IContainer.class);
        Configuration config = (Configuration)container.getEventDispatcher();
        if (config != null) {
            svc.setRootConfig(config);
        }
        return svc;
    }

    public void destroy() {
    }

    protected final String getPropertyFromInitParams(FilterConfig filterConfig, String propertyName, String defaultValue) {
        String value = filterConfig.getInitParameter(propertyName);
        if (value != null) {
            return value;
        }
        value = filterConfig.getServletContext().getInitParameter(propertyName);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }
}

