/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.BOX;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.ContainerHolder;
import aurora.plugin.source.gen.screen.model.Dataset;
import aurora.plugin.source.gen.screen.model.QueryFormBody;
import aurora.plugin.source.gen.screen.model.QueryFormToolBar;
import java.util.List;

public class QueryForm
extends BOX {
    public static final String QUERY_FORM = "queryForm";
    public static String DEFAULT_QUERY_FIELD_KEY = "defaultQueryField";
    public static String DEFAULT_QUERY_HINT_KEY = "defaultQueryHint";
    public static String RESULT_TARGET_CONTAINER_HOLDER_KEY = "resultTargetHolderContainer";
    public static String QUERY_HOOK_KEY = "queryHook";
    private QueryFormToolBar toolBar = new QueryFormToolBar();
    private String defaultQueryField = "";
    private String defaultQueryHint = "";
    private ContainerHolder resultTargetContainer = null;

    public QueryForm() {
        this.setComponentType(QUERY_FORM);
        Dataset ds = new Dataset();
        ds.setComponentType("querydataset");
        this.setDataset(ds);
        this.setSectionType("SECTION_TYPE_QUERY");
        this.setCol(1);
        this.toolBar.setDataset(this.getDataset());
        this.addChild(this.toolBar);
        this.addPropertyChangeListener(this.toolBar);
        this.resultTargetContainer = new ContainerHolder();
        this.resultTargetContainer.setOwner(this);
        this.resultTargetContainer.addContainerType("SECTION_TYPE_RESULT");
        this.setSize(600, 400);
    }

    @Override
    public int getHeadHight() {
        return 0;
    }

    public QueryFormToolBar getToolBar() {
        for (AuroraComponent ac : this.getChildren()) {
            if (!(ac instanceof QueryFormToolBar)) continue;
            return (QueryFormToolBar)ac;
        }
        return null;
    }

    public QueryFormBody getBody() {
        for (AuroraComponent ac : this.getChildren()) {
            if (!(ac instanceof QueryFormBody)) continue;
            return (QueryFormBody)ac;
        }
        return null;
    }

    @Override
    public void setDataset(Dataset ds) {
        QueryFormBody body;
        super.setDataset(ds);
        if (this.toolBar != null) {
            this.toolBar.setDataset(ds);
        }
        if ((body = this.getBody()) != null) {
            body.setDataset(ds);
        }
    }

    @Override
    public Object getPropertyValue(String propName) {
        if (DEFAULT_QUERY_FIELD_KEY.equals(propName)) {
            return this.getDefaultQueryField();
        }
        if (DEFAULT_QUERY_HINT_KEY.equals(propName)) {
            return this.getDefaultQueryHint();
        }
        if (RESULT_TARGET_CONTAINER_HOLDER_KEY.equals(propName)) {
            return this.getResultTargetContainer();
        }
        if ("resultTargetContainer".equals(propName)) {
            return this.getResultTargetContainer().getTarget();
        }
        if ("queryFormBody".equals(propName)) {
            return this.getBody();
        }
        if ("query_form_toolbar_children".equals(propName)) {
            return this.toolBar.getHBox().getPropertyValue("component_children");
        }
        if ("query_form_toolbar".equals(propName)) {
            return this.toolBar;
        }
        if ("labelWidth".equals(propName) && this.toolBar != null) {
            return this.toolBar.getLabelWidth();
        }
        return super.getPropertyValue(propName);
    }

    @Override
    public void setPropertyValue(String propName, Object val) {
        if (DEFAULT_QUERY_FIELD_KEY.equals(propName)) {
            this.setDefaultQueryField((String)val);
        } else if (DEFAULT_QUERY_HINT_KEY.equals(propName)) {
            this.setDefaultQueryHint((String)val);
        } else if (RESULT_TARGET_CONTAINER_HOLDER_KEY.equals(propName)) {
            this.setResultTargetContainer((ContainerHolder)val);
        } else if ("resultTargetContainer".equals(propName) && val instanceof Container) {
            this.getResultTargetContainer().setTarget((Container)val);
        } else if ("queryFormBody".equals(propName) && val instanceof QueryFormBody) {
            this.addChild((AuroraComponent)val);
        } else if ("query_form_toolbar_children".equals(propName) && val instanceof List) {
            this.toolBar.getHBox().setPropertyValue("component_children", val);
        } else if ("labelWidth".equals(propName)) {
            if (this.toolBar != null) {
                this.toolBar.setLabelWidth(val);
            }
        } else {
            super.setPropertyValue(propName, val);
        }
    }

    public String getDefaultQueryField() {
        return this.defaultQueryField;
    }

    public void setDefaultQueryField(String defaultQueryField) {
        this.defaultQueryField = defaultQueryField;
    }

    public String getDefaultQueryHint() {
        return this.defaultQueryHint;
    }

    public void setDefaultQueryHint(String defaultQueryHint) {
        String old = this.defaultQueryField;
        this.defaultQueryHint = defaultQueryHint;
        this.firePropertyChange(DEFAULT_QUERY_HINT_KEY, old, defaultQueryHint);
    }

    public ContainerHolder getResultTargetContainer() {
        return this.resultTargetContainer;
    }

    public void setResultTargetContainer(ContainerHolder resultTargetContainer) {
        this.resultTargetContainer = resultTargetContainer;
        resultTargetContainer.setOwner(this);
    }

    @Override
    public boolean isResponsibleChild(AuroraComponent component) {
        if (component instanceof QueryFormToolBar) {
            return this.getToolBar() == null;
        }
        if (component instanceof QueryFormBody) {
            return this.getBody() == null;
        }
        return false;
    }
}

