/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.DatasetBinder;
import aurora.plugin.source.gen.screen.model.DatasetField;
import aurora.plugin.source.gen.screen.model.IDatasetFieldDelegate;
import java.beans.PropertyChangeListener;

public abstract class Input
extends AuroraComponent
implements IDatasetFieldDelegate,
DatasetBinder {
    public static final String TEXT = "textField";
    public static final String NUMBER = "numberField";
    public static final String Combo = "comboBox";
    public static final String LOV = "lov";
    public static final String DATE_PICKER = "datePicker";
    public static final String DATETIMEPICKER = "dateTimePicker";
    public static final String CASE_LOWER = "lower";
    public static final String CASE_UPPER = "upper";
    public static final String CASE_ANY = "";
    public static final String[] CASE_TYPES = new String[]{"", "upper", "lower"};
    private static final String[] CAL_ENABLES = new String[]{"pre", "next", "both", "none"};
    public static final String[] INPUT_TYPES = new String[]{"textField", "numberField", "comboBox", "lov", "datePicker", "dateTimePicker", "checkBox"};
    public static final String ALLOWDECIMALS = "allowDecimals";
    public static final String ALLOWNEGATIVE = "allowNegative";
    public static final String ALLOWFORMAT = "allowFormat";
    public static final String EMPTYTEXT = "emptyText";
    public static final String TYPECASE = "typeCase";
    public static final String ENABLE_BESIDE_DAYS = "enableBesideDays";
    public static final String ENABLE_MONTH_BTN = "enableMonthBtn";
    private DatasetField dsField;

    public Input() {
        this.setSize(120, 20);
        this.setComponentType(TEXT);
        this.setAllowDecimals(true);
        this.setAllowFormat(false);
        this.setAllowNegative(true);
        this.setEmptyText(CASE_ANY);
        this.setEnableBesideDays(CAL_ENABLES[3]);
        this.setTypeCase(CASE_ANY);
        this.setEnableMonthBtn(CAL_ENABLES[3]);
        this.setDatasetField(new DatasetField());
    }

    public boolean isRequired() {
        return this.dsField.isRequired();
    }

    public void setRequired(boolean required) {
        this.dsField.setRequired(required);
    }

    public boolean isReadOnly() {
        return this.getDatasetField().isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.getDatasetField().setReadOnly(readOnly);
    }

    public boolean isAllowDecimals() {
        return this.getBooleanPropertyValue(ALLOWDECIMALS);
    }

    public void setAllowDecimals(boolean allowDecimals) {
        this.setPropertyValue(ALLOWDECIMALS, allowDecimals);
    }

    public boolean isAllowNegative() {
        return this.getBooleanPropertyValue(ALLOWNEGATIVE);
    }

    public void setAllowNegative(boolean allowNegative) {
        this.setPropertyValue(ALLOWNEGATIVE, allowNegative);
    }

    public boolean isAllowFormat() {
        return this.getBooleanPropertyValue(ALLOWFORMAT);
    }

    public void setAllowFormat(boolean allowFormat) {
        this.setPropertyValue(ALLOWFORMAT, allowFormat);
    }

    public String getEmptyText() {
        return this.getStringPropertyValue(EMPTYTEXT);
    }

    public void setEmptyText(String emptyText) {
        this.setPropertyValue(EMPTYTEXT, emptyText);
    }

    public String getTypeCase() {
        return this.getStringPropertyValue(TYPECASE);
    }

    public void setTypeCase(String typeCase) {
        this.setPropertyValue(TYPECASE, typeCase);
    }

    public String getEnableBesideDays() {
        return this.getStringPropertyValue(ENABLE_BESIDE_DAYS);
    }

    public void setEnableBesideDays(String enableBesideDays) {
        this.setPropertyValue(ENABLE_BESIDE_DAYS, enableBesideDays);
    }

    public String getEnableMonthBtn() {
        return this.getStringPropertyValue(ENABLE_MONTH_BTN);
    }

    public void setEnableMonthBtn(String enableMonthBtn) {
        this.setPropertyValue(ENABLE_MONTH_BTN, enableMonthBtn);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.getDatasetField().setName(name);
    }

    private int indexOf(Object[] objs, Object o) {
        int i = 0;
        while (i < objs.length) {
            if (objs[i].equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public DatasetField getDatasetField() {
        return this.dsField;
    }

    @Override
    public void setParent(Container part) {
        super.setParent(part);
    }

    @Override
    public void setDatasetField(DatasetField field) {
        this.dsField = field;
        this.dsField.setName(this.getName());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        if (this.dsField != null) {
            this.dsField.addPropertyChangeListener(l);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        super.removePropertyChangeListener(l);
        if (this.dsField != null) {
            this.dsField.removePropertyChangeListener(l);
        }
    }

    @Override
    public Object getPropertyValue(String propId) {
        if ("i_dataset_field_delegate".equals(propId)) {
            return this.dsField;
        }
        Object propertyValue = super.getPropertyValue(propId);
        return propertyValue;
    }

    @Override
    public void setPropertyValue(String propId, Object val) {
        if ("i_dataset_field_delegate".equals(propId) && val instanceof DatasetField) {
            this.setDatasetField((DatasetField)val);
            return;
        }
        super.setPropertyValue(propId, val);
    }
}

