/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.source.gen.screen.model;

import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.ButtonClicker;
import aurora.plugin.source.gen.screen.model.Toolbar;
import java.util.Arrays;

public class Button
extends AuroraComponent {
    public static final String BUTTON = "button";
    public static final String ADD = "add";
    public static final String SAVE = "save";
    public static final String DELETE = "delete";
    public static final String CLEAR = "clear";
    public static final String EXCEL = "excel";
    public static final String DEFAULT = "";
    public static final String[] std_types = new String[]{"", "add", "save", "delete", "clear", "excel"};
    public static final String BUTTON_TYPE = "type";
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_CLICKER = "click";
    public static final String TOOLTIP = "title";
    private ButtonClicker buttonClicker;

    public Button() {
        this.setSize(80, 20);
        this.setComponentType(BUTTON);
        this.setButtonClicker(new ButtonClicker());
        this.setButtonType(DEFAULT);
        this.setText(BUTTON);
    }

    @Override
    public void setSize(int width, int height) {
        if (this.isOnToolBar()) {
            height = 20;
            if (this.isStdButton()) {
                width = 48;
            }
        }
        super.setSize(width, height);
    }

    private boolean isStdButton() {
        return BUTTON.equals(this.getComponentType()) && Arrays.asList(std_types).indexOf(this.getButtonType()) > 0;
    }

    public String getButtonType() {
        return this.getStringPropertyValue(BUTTON_TYPE);
    }

    public String getIcon() {
        return this.getStringPropertyValue("icon");
    }

    public String getTitle() {
        return this.getStringPropertyValue(TOOLTIP);
    }

    public void setButtonType(String buttonType) {
        this.setPropertyValue(BUTTON_TYPE, buttonType);
    }

    public void setIcon(String i) {
        this.setPropertyValue("icon", i);
    }

    public void setText(String text) {
        this.setPropertyValue(BUTTON_TEXT, text);
    }

    public String getText() {
        return this.getStringPropertyValue(BUTTON_TEXT);
    }

    public void setTitle(String title) {
        this.setPropertyValue(TOOLTIP, title);
    }

    public boolean isOnToolBar() {
        return this.getParent() instanceof Toolbar;
    }

    public ButtonClicker getButtonClicker() {
        return this.buttonClicker;
    }

    public void setButtonClicker(ButtonClicker buttonClicker) {
        buttonClicker.setButton(this);
        this.buttonClicker = buttonClicker;
    }

    @Override
    public Object getPropertyValue(String propId) {
        if ("button_clicker".equals(propId)) {
            return this.buttonClicker;
        }
        Object propertyValue = super.getPropertyValue(propId);
        return propertyValue;
    }

    @Override
    public void setPropertyValue(String propId, Object val) {
        if ("button_clicker".equals(propId) && val instanceof ButtonClicker) {
            this.setButtonClicker((ButtonClicker)val);
            return;
        }
        if (BUTTON_TYPE.equals(propId)) {
            super.setPropertyValue(propId, val);
            if (this.isStdButton()) {
                super.setSize(48, 20);
            }
        }
        super.setPropertyValue(propId, val);
    }
}

