/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.AuroraIDocException;
import aurora.plugin.sap.sync.idoc.DatabaseTool;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocProcessManager;
import aurora.plugin.sap.sync.idoc.IDocServerManager;
import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.idoc.jco.JCoIDocHandlerFactory;
import com.sap.conn.idoc.jco.JCoIDocServer;
import com.sap.conn.idoc.jco.JCoIDocServerContext;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerContextInfo;
import com.sap.conn.jco.server.JCoServerErrorListener;
import com.sap.conn.jco.server.JCoServerExceptionListener;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.server.JCoServerTIDHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import uncertain.logging.ILogger;

public class IDocFileListener {
    private IDocServerManager serverManager;
    private IDocProcessManager iDocProcessManager;
    private String serverName;
    private ILogger logger;
    public JCoIDocServer jcoIDocServer;
    private int idocServerId = -1;

    public IDocFileListener(IDocServerManager serverManager, String serverName, IDocProcessManager iDocProcessManager) {
        this.serverManager = serverManager;
        this.serverName = serverName;
        this.iDocProcessManager = iDocProcessManager;
        this.logger = serverManager.getLogger();
    }

    public void start() {
        block13: {
            if (!this.serverManager.isRunning()) {
                return;
            }
            String processMessage = "";
            DatabaseTool dbTool = null;
            try {
                try {
                    dbTool = this.serverManager.getDatabaseTool();
                    if (this.jcoIDocServer == null) {
                        processMessage = "start IDocServer " + this.serverName;
                        this.jcoIDocServer = JCoIDoc.getServer((String)this.serverName);
                        this.addListeners();
                        this.logger.config(String.valueOf(this.serverName) + " ConnectionCount= " + this.jcoIDocServer.getConnectionCount());
                        if (this.jcoIDocServer.getConnectionCount() == 0) {
                            this.jcoIDocServer.setConnectionCount(1);
                        }
                    }
                    if (this.idocServerId < 0) {
                        processMessage = "fetch idocServerId for IDocServer " + this.serverName;
                        this.idocServerId = dbTool.addIDocServer(this.jcoIDocServer, this.serverName);
                        this.logger.log("IDocServer " + this.serverName + " 's idoc_server_id is " + this.idocServerId);
                        String programID = this.jcoIDocServer.getProgramID();
                        processMessage = "fetch fetchUnsettledIdocFiles for programID " + programID;
                        if (this.serverManager.isDebug()) {
                            FetchUnsettleIDocFile idocFile = new FetchUnsettleIDocFile(programID);
                            idocFile.start();
                        } else {
                            this.fetchUnsettledIdocFiles(dbTool, programID);
                        }
                    }
                    this.jcoIDocServer.start();
                    if (!this.isRunning()) {
                        System.err.println("Connect IDocServer " + this.serverName + " failed!");
                        this.logger.log(String.valueOf(this.serverName) + "'s status is " + this.jcoIDocServer.getState());
                        dbTool.updateIDocServerStatus(this.idocServerId, "Error occurred:please check the console or log for details.");
                        break block13;
                    }
                    if (this.serverManager.isEnabledJCo()) {
                        this.serverManager.addDestination(this.jcoIDocServer.getRepositoryDestination());
                    }
                    System.out.println("Connect IDocServer " + this.serverName + " successful!");
                    this.logger.log("Connect IDocServer " + this.serverName + " successful!");
                    dbTool.updateIDocServerStatus(this.idocServerId, "OK");
                }
                catch (Throwable e) {
                    System.err.println("Error! Connect IDocServer " + this.serverName + " failed!");
                    this.logger.log(Level.SEVERE, processMessage, e);
                    this.serverManager.closeDatabaseTool(dbTool);
                }
            }
            finally {
                this.serverManager.closeDatabaseTool(dbTool);
            }
        }
    }

    public void fetchUnsettledIdocFiles(DatabaseTool databaseManager, String programID) throws AuroraIDocException {
        List<IDocFile> unsettledIdocFiles = databaseManager.fetchUnsettledIdocFiles(programID);
        if (unsettledIdocFiles != null) {
            this.iDocProcessManager.addSyncFileAll(unsettledIdocFiles);
        }
    }

    private void addListeners() {
        IDocHandlerFactory idocHanlerFactory = new IDocHandlerFactory();
        this.jcoIDocServer.setIDocHandlerFactory((JCoIDocHandlerFactory)idocHanlerFactory);
        this.jcoIDocServer.setTIDHandler((JCoServerTIDHandler)new TidHandler());
        ThrowableListener listener = new ThrowableListener();
        this.jcoIDocServer.addServerErrorListener((JCoServerErrorListener)listener);
        this.jcoIDocServer.addServerExceptionListener((JCoServerExceptionListener)listener);
    }

    public void addCDATATag(String idocFile) throws IOException {
        BufferedReader br = null;
        PrintWriter pw = null;
        File sourceFile = new File(idocFile);
        File destFile = new File(String.valueOf(idocFile) + ".temp");
        boolean containSpecialChar = false;
        try {
            br = new BufferedReader(new FileReader(sourceFile));
            pw = new PrintWriter(new FileWriter(destFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                int index = line.indexOf("&");
                if (index != -1) {
                    containSpecialChar = true;
                    int firstTagEnd = line.indexOf(">");
                    int secondTagbegin = line.indexOf("<", index);
                    if (firstTagEnd < index && secondTagbegin != -1) {
                        String text = "<![CDATA[" + line.substring(firstTagEnd + 1, secondTagbegin) + "]]>";
                        line = String.valueOf(line.substring(0, firstTagEnd + 1)) + text + line.substring(secondTagbegin);
                    }
                }
                pw.println(line);
            }
            br.close();
            pw.flush();
            pw.close();
            if (containSpecialChar) {
                if (sourceFile.delete()) {
                    destFile.renameTo(new File(idocFile));
                }
            } else {
                destFile.delete();
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (pw != null) {
                pw.close();
            }
        }
    }

    public boolean isRunning() {
        if (this.jcoIDocServer == null) {
            return false;
        }
        JCoServerState jCoServerState = this.jcoIDocServer.getState();
        return JCoServerState.ALIVE.equals((Object)jCoServerState) || JCoServerState.STARTED.equals((Object)jCoServerState);
    }

    public boolean isStoped() {
        if (this.jcoIDocServer == null) {
            return true;
        }
        JCoServerState jCoServerState = this.jcoIDocServer.getState();
        return JCoServerState.STOPPED.equals((Object)jCoServerState);
    }

    public int getIDocServerId() {
        return this.idocServerId;
    }

    public void setIDocServerId(int idocServerId) {
        this.idocServerId = idocServerId;
    }

    public JCoIDocServer getJCoIDocServer() {
        return this.jcoIDocServer;
    }

    public void shutdown() {
        block6: {
            if (this.idocServerId != -1) {
                DatabaseTool dbTool = null;
                try {
                    try {
                        dbTool = this.serverManager.getDatabaseTool();
                        dbTool.updateIDocServerStatus(this.idocServerId, "disconnect");
                    }
                    catch (Throwable e) {
                        this.logger.log(Level.SEVERE, "", e);
                        this.serverManager.closeDatabaseTool(dbTool);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.serverManager.closeDatabaseTool(dbTool);
                    throw throwable;
                }
                this.serverManager.closeDatabaseTool(dbTool);
            }
        }
        this.logger.log("disconnect iDocServer \uff1a" + this.serverName);
        this.stopIDocServer();
    }

    private void stopIDocServer() {
        try {
            if (!this.isStoped()) {
                this.jcoIDocServer.stop();
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "", e);
        }
    }

    class FetchUnsettleIDocFile
    extends Thread {
        String programID;

        public FetchUnsettleIDocFile(String programID) {
            this.programID = programID;
        }

        @Override
        public void run() {
            while (IDocFileListener.this.serverManager.isRunning()) {
                this.sleepOneSecond();
                if (!IDocFileListener.this.iDocProcessManager.isSyncFileEmpty()) continue;
                DatabaseTool dbTool = null;
                try {
                    try {
                        dbTool = IDocFileListener.this.serverManager.getDatabaseTool();
                        IDocFileListener.this.fetchUnsettledIdocFiles(dbTool, this.programID);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (dbTool == null) continue;
                        dbTool.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (dbTool != null) {
                        dbTool.close();
                    }
                    throw throwable;
                }
                if (dbTool == null) continue;
                dbTool.close();
            }
        }

        private void sleepOneSecond() {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class IDocHandler
    implements JCoIDocHandler {
        private String idocFileDir;

        IDocHandler() {
            this.idocFileDir = IDocFileListener.this.serverManager.getIdocFileDir();
        }

        public void handleRequest(JCoServerContext serverCtx, IDocDocumentList idocList) {
            block5: {
                FileOutputStream fos = null;
                OutputStreamWriter osw = null;
                DatabaseTool dbTool = null;
                try {
                    try {
                        IDocXMLProcessor xmlProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();
                        String fileName = String.valueOf(serverCtx.getTID()) + "_idoc.xml";
                        File file = new File(this.idocFileDir, fileName);
                        String fileFullPath = file.getCanonicalPath();
                        fos = new FileOutputStream(file);
                        osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                        xmlProcessor.render(idocList, (Writer)osw, 7);
                        osw.flush();
                        osw.close();
                        dbTool = IDocFileListener.this.serverManager.getDatabaseTool();
                        int idocFileId = dbTool.addIDocFile(IDocFileListener.this.idocServerId, fileFullPath);
                        IDocFileListener.this.logger.config("Receive idoc file. fileName=" + fileName + " and id=" + idocFileId);
                        IDocFile idocFile = new IDocFile(fileFullPath, idocFileId, IDocFileListener.this.idocServerId);
                        IDocFileListener.this.iDocProcessManager.addSyncFile(idocFile);
                    }
                    catch (Throwable e) {
                        IDocFileListener.this.logger.log(Level.SEVERE, "", e);
                        this.closeOutputStreamWriter(osw);
                        this.closeFileOutputStream(fos);
                        this.closeDatabaseManager(dbTool);
                        break block5;
                    }
                }
                catch (Throwable throwable) {
                    this.closeOutputStreamWriter(osw);
                    this.closeFileOutputStream(fos);
                    this.closeDatabaseManager(dbTool);
                    throw throwable;
                }
                this.closeOutputStreamWriter(osw);
                this.closeFileOutputStream(fos);
                this.closeDatabaseManager(dbTool);
            }
        }

        private void closeOutputStreamWriter(OutputStreamWriter osw) {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    IDocFileListener.this.logger.log(Level.SEVERE, "", (Throwable)e);
                }
            }
        }

        private void closeFileOutputStream(FileOutputStream fos) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    IDocFileListener.this.logger.log(Level.SEVERE, "", (Throwable)e);
                }
            }
        }

        private void closeDatabaseManager(DatabaseTool dm) {
            if (dm != null) {
                dm.close();
            }
        }
    }

    class IDocHandlerFactory
    implements JCoIDocHandlerFactory {
        private JCoIDocHandler handler;

        IDocHandlerFactory() {
            this.handler = new IDocHandler();
        }

        public JCoIDocHandler getIDocHandler(JCoIDocServerContext serverCtx) {
            return this.handler;
        }

        public JCoIDocHandler getIDocHandler() {
            return this.handler;
        }
    }

    class ThrowableListener
    implements JCoServerErrorListener,
    JCoServerExceptionListener {
        ThrowableListener() {
        }

        public void serverErrorOccurred(JCoServer server, String connectionId, JCoServerContextInfo ctx, Error error) {
            IDocFileListener.this.logger.log(Level.SEVERE, ">>> Error occured on " + server.getProgramID() + " connection " + connectionId, (Throwable)error);
        }

        public void serverExceptionOccurred(JCoServer server, String connectionId, JCoServerContextInfo ctx, Exception error) {
            IDocFileListener.this.logger.log(Level.SEVERE, ">>> Exception occured on " + server.getProgramID() + " connection " + connectionId, (Throwable)error);
        }
    }

    class TidHandler
    implements JCoServerTIDHandler {
        TidHandler() {
        }

        public boolean checkTID(JCoServerContext serverCtx, String tid) {
            return true;
        }

        public void confirmTID(JCoServerContext serverCtx, String tid) {
        }

        public void commit(JCoServerContext serverCtx, String tid) {
        }

        public void rollback(JCoServerContext serverCtx, String tid) {
        }
    }
}

