/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.AuroraIDocException;
import aurora.plugin.sap.sync.idoc.DatabaseTool;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocProcessManager;
import aurora.plugin.sap.sync.idoc.IDocServerManager;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import aurora.service.ServiceThreadLocal;
import java.sql.Connection;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class FeedbackProcessor
implements Runnable {
    private IObjectRegistry registry;
    private IDocServerManager serverManager;
    private IDocProcessManager iDocProcessManager;
    private DatabaseTool dbTool;
    private ILogger logger;

    public FeedbackProcessor(IDocServerManager serverManager, IDocProcessManager iDocProcessManager) {
        this.serverManager = serverManager;
        this.iDocProcessManager = iDocProcessManager;
        this.registry = serverManager.getRegistry();
        this.logger = serverManager.getLogger();
    }

    @Override
    public void run() {
        while (this.serverManager.isRunning()) {
            IDocFile idocFile = this.iDocProcessManager.pollFeedbackFile();
            if (idocFile == null) {
                this.sleepOneSecond();
                continue;
            }
            this.executeFeedbackProc(idocFile);
        }
    }

    private void executeFeedbackProc(IDocFile idocFile) {
        int idocFileId = idocFile.getIdocFileId();
        try {
            this.dbTool = this.serverManager.getDatabaseTool();
            String feedback_proc = this.dbTool.queryFeedbackProc(idocFileId);
            if (feedback_proc == null) {
                return;
            }
            try {
                this.executeProc(idocFile, feedback_proc, this.dbTool.getConnection());
                this.logger.log("idoc_file_id=" + idocFile.getIdocFileId() + " load procedure:{0} successful.", new Object[]{feedback_proc});
                this.recordFeedback(idocFileId, "DONE", "");
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "idoc_file_id=" + idocFile.getIdocFileId(), e);
                this.recordFeedback(idocFileId, "EXCEPTION", AuroraIDocException.getExceptionStackTrace(e));
            }
        }
        finally {
            this.serverManager.closeDatabaseTool(this.dbTool);
        }
    }

    private void recordFeedback(int idoc_file_id, String status, String message) {
        try {
            this.dbTool.recordFeedback(idoc_file_id, status, message);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "", e);
        }
    }

    private void executeProc(IDocFile idocFile, String procedure_name, Connection connection) throws Exception {
        CompositeMap context = new CompositeMap("context");
        int idoc_file_id = idocFile.getIdocFileId();
        context.putObject("/parameter/@idoc_file_id", (Object)idoc_file_id, true);
        context.putObject("/session/@user_id", (Object)0, true);
        ServiceThreadLocal.setCurrentThreadContext((CompositeMap)context);
        IProcedureManager procedureManager = (IProcedureManager)this.registry.getInstanceOfType(IProcedureManager.class);
        if (procedureManager == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IProcedureManager.class, (String)this.getClass().getName());
        }
        IServiceFactory serviceFactory = (IServiceFactory)this.registry.getInstanceOfType(IServiceFactory.class);
        if (serviceFactory == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, IServiceFactory.class, (String)this.getClass().getName());
        }
        Procedure proc = procedureManager.loadProcedure(procedure_name);
        ServiceInvoker.invokeProcedureWithTransaction((String)procedure_name, (Procedure)proc, (IServiceFactory)serviceFactory, (CompositeMap)context, (Connection)connection);
    }

    private void sleepOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

