/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.quartz;

import aurora.plugin.quartz.JobInstance;
import java.util.HashMap;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import uncertain.core.IGlobalInstance;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class SchedulerConfig
implements IGlobalInstance {
    public static final String KEY_UE = "IObjectRegistry";
    public static final String LOGGING_TOPIC = "aurora.plugin.quartz";
    private static IObjectRegistry registry;
    SchedulerFactory schedulerFactory;
    Scheduler scheduler;
    JobDetail[] jobs;
    Trigger[] triggers;
    JobInstance[] instances;
    HashMap job_map = new HashMap();
    HashMap trigger_map = new HashMap();
    ILogger logger;
    boolean Debug = false;

    public SchedulerConfig(IObjectRegistry registry) {
        SchedulerConfig.registry = registry;
        this.schedulerFactory = new StdSchedulerFactory();
    }

    public static IObjectRegistry getObjectRegistry(JobDataMap m) {
        return (IObjectRegistry)m.get((Object)KEY_UE);
    }

    public static IObjectRegistry getObjectRegistry() {
        return registry;
    }

    public JobDetail[] getJobs() {
        return this.jobs;
    }

    public void setJobs(JobDetail[] jobs) {
        this.jobs = jobs;
        int i = 0;
        while (i < jobs.length) {
            JobDetail job = jobs[i];
            if (job.getGroup() == null) {
                job.setGroup("DEFAULT");
            }
            JobDataMap m = job.getJobDataMap();
            m.put((Object)KEY_UE, (Object)registry);
            this.job_map.put(job.getName(), job);
            if (this.Debug) {
                System.out.println("Added job " + job.toString());
            }
            ++i;
        }
    }

    public Trigger[] getTriggers() {
        return this.triggers;
    }

    public void setTriggers(Trigger[] t) {
        this.triggers = t;
        int i = 0;
        while (i < this.triggers.length) {
            Trigger trigger = this.triggers[i];
            if (trigger.getGroup() == null) {
                trigger.setGroup("DEFAULT");
            }
            this.trigger_map.put(trigger.getName(), trigger);
            if (this.Debug) {
                System.out.println("Added trigger " + trigger.toString());
            }
            ++i;
        }
    }

    public JobInstance[] getInstances() {
        return this.instances;
    }

    public JobDetail getJobDetail(String name) {
        return (JobDetail)this.job_map.get(name);
    }

    public Trigger getTrigger(String name) {
        return (Trigger)this.trigger_map.get(name);
    }

    public void setInstances(JobInstance[] instances) {
        this.instances = instances;
    }

    public void onInitialize() throws Exception {
        this.logger = LoggingContext.getLogger((String)LOGGING_TOPIC, (IObjectRegistry)registry);
        try {
            this.scheduler = this.schedulerFactory.getScheduler();
        }
        catch (Throwable er) {
            er.printStackTrace();
        }
        registry.registerInstance(SchedulerFactory.class, (Object)this.schedulerFactory);
        registry.registerInstance(Scheduler.class, (Object)this.scheduler);
        int count = 0;
        count = 0;
        while (count < this.instances.length) {
            Trigger trigger;
            JobInstance ji = this.instances[count];
            JobDetail job = this.getJobDetail(ji.getJobName());
            if (job == null) {
                this.logger.warning("Job '" + ji.getJobName() + "' is not defined");
            }
            if ((trigger = this.getTrigger(ji.getTriggerName())) == null) {
                this.logger.warning("Trigger '" + ji.getTriggerName() + "' is not defined");
            }
            try {
                this.scheduler.scheduleJob(job, trigger);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            ++count;
        }
        if (count == 0) {
            this.logger.warning("No job instances defined");
        } else {
            this.scheduler.start();
            this.logger.info("Quartz scheduler started," + count + " jobs running");
        }
    }

    public void onShutdown() throws SchedulerException, InterruptedException {
        this.logger.info("Quartz scheduler shutdown");
        this.scheduler.shutdown(true);
    }
}

