/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity.model;

import aurora.plugin.entity.model.IEntityConst;
import aurora.plugin.entity.model.ModelUtil;
import aurora.plugin.entity.model.PkRecord;
import aurora.plugin.entity.model.Record;
import aurora.plugin.entity.model.RecordPropertyChangeEvent;
import aurora.plugin.entity.model.Relation;
import aurora.plugin.entity.model.RelationPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class BMModel
implements IEntityConst {
    public static final String STRUCTURE_RECORD = "structure_record";
    public static final String STRUCTURE_RELATION = "structure_relation";
    public static final String TITLE = "title";
    public static final String AUTOEXTEND = "autoextend";
    public static final String DEFAULT_DISPLAY = "defaultdisplay";
    private String FIELD_NAME_PREFIX = "c";
    public static final int RECORD = 0;
    public static final int RELATION = 1;
    private ArrayList<Record> records = new ArrayList();
    private ArrayList<Relation> relations = new ArrayList();
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private String name = "";
    private String autoExtend = "";
    private String defaultDiaplay = "";
    private Record pkRecord = new PkRecord();
    private PropertyChangeListener recordListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RecordPropertyChangeEvent event = new RecordPropertyChangeEvent(evt);
            BMModel.this.firePropertyChange(event);
        }
    };
    private PropertyChangeListener relationListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RelationPropertyChangeEvent event = new RelationPropertyChangeEvent(evt);
            BMModel.this.firePropertyChange(event);
        }
    };

    public ArrayList<Record> getRecordList() {
        return this.records;
    }

    public ArrayList<Relation> getRelationList() {
        return this.relations;
    }

    public void setDefaultDisplay(String prompt) {
        String old = this.defaultDiaplay;
        this.defaultDiaplay = prompt;
        this.firePropertyChange(DEFAULT_DISPLAY, old, prompt);
    }

    public String getDefaultDisplay() {
        return this.defaultDiaplay;
    }

    public Record getDefaultDisplayRecord() {
        for (Record r : this.records) {
            if (!r.getPrompt().equals(this.defaultDiaplay)) continue;
            return r;
        }
        return null;
    }

    public Record[] getRecords() {
        Record[] rcds = new Record[this.records.size()];
        this.records.toArray(rcds);
        return rcds;
    }

    public Record[] getRecords(boolean includePk) {
        ArrayList<Record> list = new ArrayList<Record>(this.records.size() + 1);
        if (includePk) {
            list.add(this.pkRecord);
        }
        list.addAll(this.records);
        Record[] rcds = new Record[list.size()];
        list.toArray(rcds);
        return rcds;
    }

    public Relation[] getRelations() {
        Relation[] rels = new Relation[this.relations.size()];
        this.relations.toArray(rels);
        return rels;
    }

    public int add(Record record) {
        this.records.add(record);
        this.notifyModidy();
        return this.records.size() - 1;
    }

    public int add(Relation rel) {
        this.relations.add(rel);
        this.notifyRelationChange();
        return this.relations.size() - 1;
    }

    public void add(int idx, Record r) {
        this.records.add(idx, r);
        this.notifyModidy();
    }

    public void add(int idx, Relation rel) {
        this.relations.add(idx, rel);
        this.notifyRelationChange();
    }

    public void remove(Record r) {
        this.records.remove(r);
        this.notifyModidy();
    }

    public void remove(Relation rel) {
        this.relations.remove(rel);
        this.notifyRelationChange();
    }

    public Record removeRecord(int idx) {
        Record r = this.records.remove(idx);
        this.notifyModidy();
        return r;
    }

    public Relation removeRelation(int idx) {
        Relation rel = this.relations.remove(idx);
        this.notifyRelationChange();
        return rel;
    }

    private void notifyModidy() {
        ArrayList<Record> unNamedRecord = new ArrayList<Record>();
        int maxNum = 0;
        int i = 0;
        while (i < this.records.size()) {
            int n;
            Record r = this.records.get(i);
            if (r.getNum() != i + 1) {
                r.setNum(i + 1);
            }
            r.removePropertyChangeListener(this.recordListener);
            r.addPropertyChangeListener(this.recordListener);
            if (r.getName().trim().length() == 0) {
                unNamedRecord.add(r);
            }
            if (r.getName().matches(String.valueOf(this.FIELD_NAME_PREFIX) + "(0|([1-9]\\d*))") && maxNum < (n = Integer.parseInt(r.getName().substring(this.FIELD_NAME_PREFIX.length())))) {
                maxNum = n;
            }
            ++i;
        }
        for (Record r : unNamedRecord) {
            r.setName(String.valueOf(this.FIELD_NAME_PREFIX) + ++maxNum);
        }
        this.firePropertyChange(STRUCTURE_RECORD, null, null);
    }

    private void notifyRelationChange() {
        int i = 0;
        while (i < this.relations.size()) {
            Relation r = this.relations.get(i);
            if (r.getNum() != i + 1) {
                r.setNum(i + 1);
            }
            r.removePropertyChangeListener(this.relationListener);
            r.addPropertyChangeListener(this.relationListener);
            ++i;
        }
        this.firePropertyChange(STRUCTURE_RELATION, null, null);
    }

    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    public boolean isFirst(Record r) {
        if (this.isEmpty()) {
            return false;
        }
        return this.records.get(0).equals(r);
    }

    public boolean isLast(Record r) {
        if (this.isEmpty()) {
            return false;
        }
        return this.records.get(this.records.size() - 1).equals(r);
    }

    public int indexOf(Record r) {
        return this.records.indexOf(r);
    }

    public Record getAt(int idx) {
        return this.records.get(idx);
    }

    public void setAt(int idx, Record r) {
        this.setAt(idx, r, false);
    }

    public void setAt(int idx, Record r, boolean quite) {
        this.records.set(idx, r);
        if (!quite) {
            this.notifyModidy();
        }
    }

    public void swap(int idx1, int idx2) {
        Record r = this.records.get(idx1);
        this.records.set(idx1, this.records.get(idx2));
        this.records.set(idx2, r);
        this.notifyModidy();
    }

    public void remove(List<Record> list) {
        this.records.removeAll(list);
        this.notifyModidy();
    }

    public void removeRelations(List<Relation> list) {
        this.relations.removeAll(list);
        this.notifyRelationChange();
    }

    public void removeAll() {
        this.records.clear();
        this.notifyModidy();
    }

    public void removeAllRelations() {
        this.relations.clear();
        this.notifyRelationChange();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    protected void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        this.listeners.firePropertyChange(event);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        if (this.name.equals(name)) {
            return;
        }
        String old = this.name;
        this.name = name;
        this.firePropertyChange(TITLE, old, name);
    }

    public void setAutoExtends(String string) {
        if (ModelUtil.eq(this.autoExtend, string)) {
            return;
        }
        String old = this.autoExtend;
        this.autoExtend = string;
        this.firePropertyChange(AUTOEXTEND, old, string);
    }

    public void setAutoExtendsArray(String[] strs) {
        this.setAutoExtends(ModelUtil.join(strs, "|"));
    }

    public String getAutoExtends() {
        return this.autoExtend;
    }

    public String[] getAutoExtendTypes() {
        if (this.autoExtend == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(this.autoExtend, "|");
        ArrayList<String> als = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim().toLowerCase();
            if (als.indexOf(s) != -1) continue;
            als.add(s);
        }
        String[] ss = new String[als.size()];
        return als.toArray(ss);
    }

    public Record getPkRecord() {
        return this.pkRecord;
    }

    public void setPkRecord(Record pkRecord) {
        this.pkRecord = pkRecord;
    }

    public void setNamePrefix(String pre) {
        this.FIELD_NAME_PREFIX = pre;
    }

    public String getNamePrefix() {
        return this.FIELD_NAME_PREFIX;
    }

    public Record getRecordByPrompt(String p) {
        return this.getRecord("prompt", p);
    }

    public Record getRecordByName(String n) {
        return this.getRecord("name", n);
    }

    public Record getRecord(String key, Object value) {
        for (Record r : this.records) {
            if (!ModelUtil.eq(r.get(key), value)) continue;
            return r;
        }
        return null;
    }
}

