/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.entity.gen;

import aurora.plugin.entity.model.BMModel;
import aurora.plugin.entity.model.DataType;
import aurora.plugin.entity.model.IEntityConst;
import aurora.plugin.entity.model.Record;
import java.util.ArrayList;

public class SqlGenerator
implements IEntityConst {
    private static final String line_sep = String.format("%n", new Object[0]);
    private static final String prefix = "    ";
    private static final String header = "create table %s (" + line_sep;
    private static final String tail = ")";
    private static final String column_model = "    %%-%ds %%s";
    private static final String comment_model = "comment on column %%-%ss is '%%s'";
    private BMModel model;
    private String name;
    private int maxNameLength = 0;

    public SqlGenerator(BMModel model, String name) {
        this.model = model;
        this.name = name;
    }

    public String[] gen() {
        ArrayList<String> sqls = new ArrayList<String>();
        Record[] rs = this.model.getRecords();
        StringBuilder sb = new StringBuilder(10000);
        sb.append(String.format(header, this.name));
        this.maxNameLength = this.getMaxNameLength();
        String cm = String.format(column_model, this.maxNameLength);
        String t = rs.length == 0 ? "" : ",";
        Record r = this.model.getPkRecord();
        sb.append(String.valueOf(String.format(cm, r.getName(), this.getSqlType(r.getType()))) + " not null" + t + line_sep);
        int i = 0;
        while (i < rs.length) {
            t = i == rs.length - 1 ? "" : ",";
            sb.append(String.valueOf(String.format(cm, rs[i].getName(), this.getSqlType(rs[i].getType()))) + t + line_sep);
            ++i;
        }
        sb.append(tail);
        sqls.add(sb.toString());
        this.addComment(sqls);
        String[] sqlArr = new String[sqls.size()];
        sqls.toArray(sqlArr);
        return sqlArr;
    }

    private void addComment(ArrayList<String> sqls) {
        String cm = String.format(comment_model, this.name.length() + 1 + this.maxNameLength);
        Record pkr = this.model.getPkRecord();
        sqls.add(String.format(cm, String.valueOf(this.name) + "." + pkr.getName(), pkr.getPrompt()));
        for (Record r : this.model.getRecordList()) {
            sqls.add(String.format(cm, String.valueOf(this.name) + "." + r.getName(), r.getPrompt()));
        }
    }

    private int getMaxNameLength() {
        int length = 0;
        for (Record r : this.model.getRecordList()) {
            int l = r.getName().length();
            if (l <= length) continue;
            length = l;
        }
        int l = this.model.getPkRecord().getName().length();
        if (l > length) {
            length = l;
        }
        return length;
    }

    private String getSqlType(String type) {
        DataType dt = DataType.fromString(type);
        if (dt == null) {
            dt = DataType.TEXT;
        }
        return dt.getSqlType();
    }
}

