/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bill99;

import aurora.plugin.bill99.Bill99;
import aurora.plugin.bill99.Configuration;
import aurora.plugin.bill99.MD5Util;
import aurora.plugin.bill99.SendReceivePKipair;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class Receive
extends AbstractEntry {
    private String merchantAcctId;
    private String key;
    private String version;
    private String language;
    private String signType;
    private String payType;
    private String bankId;
    private String orderId;
    private String orderTime;
    private String orderAmount;
    private String dealId;
    private String bankDealId;
    private String dealTime;
    private String payAmount;
    private String fee;
    private String ext1;
    private String ext2;
    private String payResult;
    private String errCode;
    private String signMsg;
    private String configFile;

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        HttpServiceInstance serviceInstance = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest request = serviceInstance.getRequest();
        request.setCharacterEncoding("GBK");
        ServiceContext service = ServiceContext.createServiceContext((CompositeMap)context);
        this.configFile = this.getValue(context, this.getConfigFile());
        CompositeMap model = service.getModel();
        CompositeMap bill99 = model.createChild("bill99");
        this.merchantAcctId = request.getParameter("merchantAcctId").trim();
        this.setKey(this.getVaule(Bill99.key));
        this.version = request.getParameter("version").trim();
        this.language = request.getParameter("language").trim();
        this.signType = request.getParameter("signType").trim();
        this.payType = request.getParameter("payType").trim();
        this.bankId = request.getParameter("bankId").trim();
        this.orderId = request.getParameter("orderId").trim();
        this.orderTime = request.getParameter("orderTime").trim();
        this.orderAmount = request.getParameter("orderAmount").trim();
        this.dealId = request.getParameter("dealId").trim();
        this.bankDealId = request.getParameter("bankDealId").trim();
        this.dealTime = request.getParameter("dealTime").trim();
        this.payAmount = request.getParameter("payAmount").trim();
        this.fee = request.getParameter("fee").trim();
        this.ext1 = request.getParameter("ext1").trim();
        this.ext2 = request.getParameter("ext2").trim();
        this.payResult = request.getParameter("payResult").trim();
        this.errCode = request.getParameter("errCode").trim();
        this.signMsg = request.getParameter("signMsg").trim();
        String merchantSignMsg = "";
        boolean isSignFail = true;
        if ("1".equals(this.signType)) {
            merchantSignMsg = this.createSignMSG();
            isSignFail = !this.signMsg.toUpperCase().equals(merchantSignMsg.toUpperCase());
        } else if ("4".equals(this.signType)) {
            SendReceivePKipair pki = new SendReceivePKipair(this.configFile);
            String createReceiveMsg = this.createPKiReceiveMsg();
            isSignFail = !pki.enCodeByCer(createReceiveMsg, this.signMsg);
        } else {
            throw new RuntimeException("\u63a5\u6536\u6765\u81ea\u5757\u94b1\u7684signType \u914d\u7f6e\u9519\u8bef\uff0c1\uff1a\u4e3aMD5\uff0c4\uff1a\u4e3a\u7b7e\u540d\u65b9\u5f0f");
        }
        bill99.put((Object)Bill99.orderAmount, (Object)this.orderAmount);
        bill99.put((Object)Bill99.orderTime, (Object)this.orderTime);
        bill99.put((Object)Bill99.payType, (Object)this.payType);
        bill99.put((Object)Bill99.bankId, (Object)this.bankId);
        bill99.put((Object)Bill99.orderId, (Object)this.orderId);
        bill99.put((Object)Bill99.merchantAcctId, (Object)this.merchantAcctId);
        bill99.put((Object)Bill99.version, (Object)this.version);
        bill99.put((Object)Bill99.language, (Object)this.language);
        bill99.put((Object)Bill99.signType, (Object)this.signType);
        bill99.put((Object)"dealId", (Object)this.dealId);
        bill99.put((Object)"bankDealId", (Object)this.bankDealId);
        bill99.put((Object)"dealTime", (Object)this.dealTime);
        bill99.put((Object)"payAmount", (Object)this.payAmount);
        bill99.put((Object)"fee", (Object)this.fee);
        bill99.put((Object)Bill99.ext1, (Object)this.ext1);
        bill99.put((Object)Bill99.ext2, (Object)this.ext2);
        bill99.put((Object)"payResult", (Object)this.payResult);
        bill99.put((Object)"errCode", (Object)this.errCode);
        bill99.put((Object)Bill99.signMsg, (Object)this.signMsg);
        bill99.put((Object)Bill99.isSignFail, (Object)isSignFail);
    }

    private String createPKiReceiveMsg() {
        String merchantSignMsgVal = "";
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "merchantAcctId", this.merchantAcctId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "version", this.version);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "language", this.language);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "signType", this.signType);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "payType", this.payType);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "bankId", this.bankId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "orderId", this.orderId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "orderTime", this.orderTime);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "orderAmount", this.orderAmount);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "dealId", this.dealId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "bankDealId", this.bankDealId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "dealTime", this.dealTime);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "payAmount", this.payAmount);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "fee", this.fee);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "ext1", this.ext1);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "ext2", this.ext2);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "payResult", this.payResult);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "errCode", this.errCode);
        return merchantSignMsgVal;
    }

    private String createSignMSG() throws UnsupportedEncodingException {
        String merchantSignMsgVal = this.createMD5ReceiveMsg();
        String merchantSignMsg = MD5Util.md5Hex(merchantSignMsgVal.getBytes("gb2312")).toUpperCase();
        return merchantSignMsg;
    }

    private String createMD5ReceiveMsg() {
        String merchantSignMsgVal = "";
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.merchantAcctId, this.merchantAcctId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.version, this.version);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.language, this.language);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.signType, this.signType);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.payType, this.payType);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.bankId, this.bankId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.orderId, this.orderId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.orderTime, this.orderTime);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.orderAmount, this.orderAmount);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "dealId", this.dealId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "bankDealId", this.bankDealId);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "dealTime", this.dealTime);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "payAmount", this.payAmount);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "fee", this.fee);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.ext1, this.ext1);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.ext2, this.ext2);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "payResult", this.payResult);
        merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, "errCode", this.errCode);
        if ("1".equals(this.signType)) {
            merchantSignMsgVal = Bill99.appendParam(merchantSignMsgVal, Bill99.key, this.getKey());
        }
        return merchantSignMsgVal;
    }

    private String getVaule(String key) {
        String value = Configuration.getValue(this.configFile, key);
        return value == null ? "" : value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    private String getValue(CompositeMap context, String key) {
        if (key != null) {
            return TextParser.parse((String)key, (CompositeMap)context);
        }
        return "";
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }
}

