/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bgtcheck.dataimport;

import aurora.datasource.DataSourceConfig;
import aurora.plugin.bgtcheck.DatabaseTool;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.util.logging.Level;
import org.apache.ibatis.jdbc.ScriptRunner;
import uncertain.core.DirectoryConfig;
import uncertain.core.UncertainEngine;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class IbatisScriptRunner {
    private IObjectRegistry mObjectRegistry;
    private Connection connection;
    private DataSourceConfig dsConfig;
    private ILogger logger;
    private static final String SCRIPTRUNNER_LOGDIRECTORY = "ScriptRunner";
    private String scriptRunnercLogDirectory;

    public IbatisScriptRunner(IObjectRegistry objectRegistry) throws Exception {
        this.mObjectRegistry = objectRegistry;
        this.connection = DatabaseTool.getContextConnection(this.mObjectRegistry);
        this.dsConfig = (DataSourceConfig)this.mObjectRegistry.getInstanceOfType(DataSourceConfig.class);
        if (this.dsConfig == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, DataSourceConfig.class, (String)this.getClass().getCanonicalName());
        }
        this.logger = LoggingContext.getLogger((String)this.getClass().getPackage().getName(), (IObjectRegistry)this.mObjectRegistry);
        Class.forName("oracle.jdbc.driver.OracleDriver").newInstance();
        this.initLogDirectory();
    }

    private void initLogDirectory() throws IOException {
        UncertainEngine ue = (UncertainEngine)this.mObjectRegistry.getInstanceOfType(UncertainEngine.class);
        if (ue == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, UncertainEngine.class, (String)this.getClass().getCanonicalName());
        }
        DirectoryConfig dc = ue.getDirectoryConfig();
        if (dc == null) {
            throw BuiltinExceptionFactory.createInstanceNotFoundException(null, DirectoryConfig.class, (String)this.getClass().getCanonicalName());
        }
        String logDirectory = dc.getLogDirectory();
        if (logDirectory == null) {
            logDirectory = new File(System.getProperty("java.io.tmpdir")).getCanonicalPath();
        }
        this.scriptRunnercLogDirectory = String.valueOf(logDirectory) + File.separator + SCRIPTRUNNER_LOGDIRECTORY;
        this.logger.info("scriptRunnercLogDirectory is " + this.scriptRunnercLogDirectory + ".");
    }

    public void executeSQL(String sqlFileFullPath) throws Exception {
        File sqlFile = new File(sqlFileFullPath);
        this.executeSQL(sqlFile);
    }

    public void executeSQL(File sqlFile) throws Exception {
        ScriptRunner runner = new ScriptRunner(this.connection);
        runner.setAutoCommit(false);
        runner.setStopOnError(true);
        File logFile = new File(String.valueOf(this.scriptRunnercLogDirectory) + File.separator + System.currentTimeMillis() + "_" + sqlFile.getName());
        if (!logFile.exists()) {
            File parentFile = logFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            logFile.createNewFile();
        }
        PrintWriter pw = new PrintWriter(logFile);
        runner.setErrorLogWriter(pw);
        runner.setLogWriter(null);
        FileReader fr = null;
        try {
            try {
                fr = new FileReader(sqlFile);
                runner.runScript((Reader)fr);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "sqlFile is " + sqlFile + ". Please check it.", (Throwable)e);
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            this.closeReader(fr);
            this.closeWriter(pw);
            throw throwable;
        }
        this.closeReader(fr);
        this.closeWriter(pw);
    }

    private void closeReader(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "", (Throwable)e);
            }
        }
    }

    private void closeWriter(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "", (Throwable)e);
            }
        }
    }
}

