/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.bgtcheck.dataimport;

import aurora.plugin.bgtcheck.dataimport.DataBaseActions;
import aurora.plugin.bgtcheck.dataimport.IbatisScriptRunner;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;
import uncertain.util.resource.ILocatable;

public class DataImport
extends AbstractEntry {
    private IObjectRegistry mRegistry;
    private ILogger logger;
    private IbatisScriptRunner scriptRunner;
    private DataBaseActions dbActions;
    private String sqlFileRootPath;

    public DataImport(IObjectRegistry registry) throws IOException {
        this.mRegistry = registry;
        this.logger = LoggingContext.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName(), (IObjectRegistry)this.mRegistry);
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        this.scriptRunner = new IbatisScriptRunner(this.mRegistry);
        this.sqlFileRootPath = TextParser.parse((String)this.sqlFileRootPath, (CompositeMap)context);
        if (this.sqlFileRootPath == null || "".equals(this.sqlFileRootPath)) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"sqlFileRootPath");
        }
        File rootDirectory = new File(this.sqlFileRootPath);
        if (!rootDirectory.exists()) {
            throw new IllegalArgumentException("sqlFileRootPath:" + this.sqlFileRootPath + " not exists!");
        }
        if (!rootDirectory.isDirectory()) {
            throw new IllegalArgumentException("sqlFileRootPath:" + this.sqlFileRootPath + " is not directory!");
        }
        this.dbActions = new DataBaseActions(this.mRegistry, this.logger);
        this.execute(0, rootDirectory);
    }

    private void execute(int parent_batch_id, File rootDirectory) throws Exception {
        ArrayList<File> sqlFileList = new ArrayList<File>();
        ArrayList<File> subDirList = new ArrayList<File>();
        this.filterDirectory(rootDirectory, sqlFileList, subDirList);
        if (sqlFileList.size() == 0 && subDirList.size() == 0) {
            return;
        }
        int batch_id = this.generateBatchId(rootDirectory);
        this.dbActions.insert_td_batch_hierarchy(batch_id, parent_batch_id);
        this.handleSQLFile(batch_id, sqlFileList);
        this.handleSubDir(batch_id, subDirList);
    }

    private int generateBatchId(File directory) throws SQLException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("file:" + directory + " is not a directory!");
        }
        String fileName = directory.getName();
        Pattern pattern = Pattern.compile("([\\w]*)(.*)");
        Matcher matcher = pattern.matcher(fileName);
        String fileCode = "";
        String fileDesc = "";
        if (matcher.find()) {
            fileCode = matcher.group(1);
            fileDesc = matcher.group(2);
        }
        int batch_id = this.dbActions.generateBatchId(fileCode, fileDesc, fileName);
        return batch_id;
    }

    private void handleSubDir(int batch_id, ArrayList<File> subDirList) throws Exception {
        for (File subDir : subDirList) {
            this.execute(batch_id, subDir);
        }
    }

    private void handleSQLFile(int batch_id, ArrayList<File> sqlFileList) throws Exception {
        for (File sqlFile : sqlFileList) {
            String fileName = sqlFile.getName();
            String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf("."));
            Pattern pattern = Pattern.compile("([\\w]*)(.*)");
            Matcher matcher = pattern.matcher(fileNameWithoutExtension);
            String tableName = "";
            String fileDesc = "";
            if (matcher.find()) {
                tableName = matcher.group(1);
                fileDesc = matcher.group(2);
            }
            this.dbActions.insert_td_batch_tables(batch_id, tableName, fileDesc, fileNameWithoutExtension);
            this.dbActions.deleteTable(tableName);
            this.scriptRunner.executeSQL(sqlFile);
            this.dbActions.copyDataToTdTable(batch_id, tableName);
        }
    }

    private void filterDirectory(File rootDirectory, ArrayList<File> sqlFileList, ArrayList<File> subDirList) {
        File[] files = rootDirectory.listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                subDirList.add(file);
            } else if (file.getName().toLowerCase().endsWith(".sql")) {
                sqlFileList.add(file);
            }
            ++n2;
        }
    }

    public String getSqlFileRootPath() {
        return this.sqlFileRootPath;
    }

    public void setSqlFileRootPath(String sqlFileRootPath) {
        this.sqlFileRootPath = sqlFileRootPath;
    }
}

