/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.ws;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.service.validation.Parameter;
import aurora.service.ws.WSDLUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.ocm.OCManager;
import uncertain.schema.Namespace;

public class BMWSDLGenerator {
    private BusinessModel model;
    private String location;
    private boolean isQueryMutiRecords = false;
    private static HashMap<String, String> xsdMap = new HashMap();
    private String soapAction;
    private static final Namespace xsd = new Namespace("xsd", "http://www.w3.org/2001/XMLSchema");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CompositeMap defaultResponse;

    static {
        xsdMap.put(String.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":string");
        xsdMap.put(Byte.TYPE.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":byte");
        xsdMap.put(Short.TYPE.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":short");
        xsdMap.put(Integer.TYPE.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":int");
        xsdMap.put(Long.TYPE.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":long");
        xsdMap.put(Long.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":long");
        xsdMap.put(Float.TYPE.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":float");
        xsdMap.put(Double.TYPE.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":double");
        xsdMap.put(Double.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":double");
        xsdMap.put(BigInteger.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":integer");
        xsdMap.put(BigDecimal.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":decimal");
        xsdMap.put(Calendar.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":dateTime");
        xsdMap.put(java.util.Date.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":dateTime");
        xsdMap.put(Clob.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":string");
        xsdMap.put(Date.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":date");
        xsdMap.put(Time.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":time");
        xsdMap.put(Timestamp.class.getCanonicalName(), String.valueOf(xsd.getPrefix()) + ":datetime");
    }

    public BMWSDLGenerator(BusinessModel model, String location, String operation) {
        this.model = model;
        this.location = location;
        this.soapAction = operation;
    }

    public BMWSDLGenerator(BusinessModel model, String location, boolean queryMutiRecords) {
        this.model = model;
        this.location = location;
        this.soapAction = "query";
        this.isQueryMutiRecords = queryMutiRecords;
    }

    public CompositeMap run() {
        CompositeMap wsdlRoot = WSDLUtil.getWSDLTemplate(this.location, "auto", this.soapAction, "http://www.aurora-framework.org/schema");
        this.createRequest(wsdlRoot);
        this.createResponse(wsdlRoot);
        return wsdlRoot;
    }

    public void createRequest(CompositeMap wsdlRoot) {
        boolean isRequest = true;
        CompositeMap schema = (CompositeMap)wsdlRoot.getObject("/types/schema");
        CompositeMap elementType = this.createType(this.soapAction, isRequest);
        schema.addChild(elementType);
        String elementTypeName = elementType.getString((Object)"name");
        CompositeMap message = WSDLUtil.createMessage(elementTypeName, isRequest);
        int index = wsdlRoot.getChilds().indexOf(wsdlRoot.getChild("types"));
        wsdlRoot.addChild(index + 1, message);
    }

    public void createResponse(CompositeMap wsdlRoot) {
        boolean isRequest = false;
        CompositeMap schema = (CompositeMap)wsdlRoot.getObject("/types/schema");
        if (this.isQueryMutiRecords) {
            CompositeMap elementType = this.createMutiResponseType(this.soapAction);
            String elementTypeName = elementType.getString((Object)"name");
            schema.addChild(elementType);
            CompositeMap message = WSDLUtil.createMessage(elementTypeName, isRequest);
            int index = wsdlRoot.getChilds().indexOf(wsdlRoot.getChild("types"));
            wsdlRoot.addChild(index + 1, message);
        } else {
            WSDLUtil.createOrientNode(this.soapAction, this.defaultResponse, "tns", wsdlRoot, isRequest);
        }
    }

    private CompositeMap createMutiResponseType(String operation) {
        boolean isRequest = false;
        LinkedList<Parameter> parameters = this.model.getParameterForOperationInList(operation);
        CompositeMap recordType = this.getMutiResponseType();
        Field[] fields = this.model.getFields();
        if (parameters == null && fields == null) {
            return recordType.getRoot();
        }
        if (parameters == null) {
            parameters = new LinkedList<Parameter>();
        }
        if (fields != null) {
            OCManager mOcManager = OCManager.getInstance();
            Parameter param = null;
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                param = new Parameter();
                CompositeMap m = field.getObjectContext();
                mOcManager.populateObject(m, (Object)param);
                param.setOutput(true);
                param.setInput(false);
                parameters.add(param);
                ++i;
            }
        }
        this.interpretParameter(parameters, recordType, isRequest);
        return recordType.getRoot();
    }

    private CompositeMap createType(String operation, boolean isRequest) {
        List parameters = this.model.getParameterForOperationInList(operation);
        CompositeMap elementType = this.getXSDCtElement("element");
        elementType.put((Object)"name", (Object)this.createName("", isRequest, WSDL_TYPES.type));
        this.interpretParameter(parameters, elementType, isRequest);
        return elementType;
    }

    private void interpretParameter(List<Parameter> parameters, CompositeMap elementType, boolean isRequest) {
        Iterator<Parameter> paraIts = parameters.iterator();
        HashSet<String> exists = new HashSet<String>();
        while (paraIts.hasNext()) {
            Parameter para = paraIts.next();
            if (isRequest && para.getInput()) {
                if (exists.contains(para.getName())) continue;
                exists.add(para.getName());
                this.addXSDAttribute(elementType, para.getName(), para.getDataType());
            }
            if (isRequest || !para.getOutput() || exists.contains(para.getName())) continue;
            exists.add(para.getName());
            this.addXSDAttribute(elementType, para.getName(), para.getDataType());
        }
    }

    private String createName(String operation, boolean isRequest, WSDL_TYPES types) {
        return String.valueOf(operation) + (isRequest ? "Request" : "Response") + (Object)((Object)types);
    }

    private CompositeMap getMutiResponseType() {
        CompositeMap records = this.getXSDNode("element");
        records.put((Object)"name", (Object)this.model.getName());
        CompositeMap complexType = this.getXSDNode("complexType");
        records.addChild(complexType);
        CompositeMap sequence = this.getXSDNode("sequence");
        complexType.addChild(sequence);
        CompositeMap record = this.getXSDNode("element");
        sequence.addChild(record);
        record.put((Object)"maxOccurs", (Object)"unbounded");
        record.put((Object)"name", (Object)"record");
        CompositeMap type = this.getXSDNode("complexType");
        record.addChild(type);
        return record;
    }

    private CompositeMap getXSDNode(String name) {
        return new CompositeMap(xsd.getPrefix(), xsd.getUrl(), name);
    }

    private CompositeMap getXSDCtElement(String name) {
        CompositeMap element = this.getXSDNode("element");
        CompositeMap complexType = this.getXSDNode("complexType");
        element.addChild(complexType);
        return element;
    }

    private void addXSDAttribute(CompositeMap element, String name, String javaType) {
        CompositeMap complexType = element.getChild("complexType");
        CompositeMap atttribute = this.getXSDNode("attribute");
        atttribute.put((Object)"name", (Object)name);
        String type = xsdMap.get(javaType);
        if (type == null) {
            throw new RuntimeException(String.valueOf(javaType) + " is not defined the map type");
        }
        atttribute.put((Object)"type", (Object)type);
        complexType.addChild(atttribute);
    }

    public CompositeMap getDefaultResponse() {
        return this.defaultResponse;
    }

    public void setDefaultResponse(CompositeMap defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    static enum WSDL_TYPES {
        type,
        message,
        portType,
        binding,
        service,
        part,
        port;

    }
}

