/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.lock;

import aurora.service.IResourceReleaser;
import aurora.service.ServiceContext;
import aurora.service.lock.IServiceSessionLock;
import aurora.service.lock.ServiceSessionLockMBean;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import uncertain.core.IGlobalInstance;
import uncertain.mbean.IMBeanNameProvider;
import uncertain.mbean.IMBeanRegister;
import uncertain.mbean.IMBeanRegistrable;

public class ServiceSessionLock
implements Serializable,
IServiceSessionLock,
IGlobalInstance,
IMBeanRegistrable,
ServiceSessionLockMBean {
    Map mResourceLockMap;
    boolean mIsRunning = true;
    TimeoutChecker mCheckThread;

    public ServiceSessionLock() {
        this.start();
    }

    public static String getKey(String session_id, String resource) {
        return String.valueOf(session_id) + "." + resource;
    }

    @Override
    public void lock(String session_id, String resource, long timeout) {
        ResourceLock lock = new ResourceLock(ServiceSessionLock.getKey(session_id, resource), timeout > 0L ? System.currentTimeMillis() + timeout : 0L);
        this.mResourceLockMap.put(lock.mKey, lock);
    }

    @Override
    public void unlock(String session_id, String resource) {
        this.mResourceLockMap.remove(ServiceSessionLock.getKey(session_id, resource));
    }

    @Override
    public boolean islocked(String session_id, String resource) {
        boolean locked = this.mResourceLockMap.containsKey(ServiceSessionLock.getKey(session_id, resource));
        return locked;
    }

    public void shutdown() {
        this.mIsRunning = false;
        this.mResourceLockMap.clear();
    }

    public void start() {
        this.mIsRunning = true;
        this.mResourceLockMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String showAllLocks() {
        Map map = this.mResourceLockMap;
        synchronized (map) {
            return this.mResourceLockMap.values().toString();
        }
    }

    @Override
    public int getLockCount() {
        return this.mResourceLockMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map map = this.mResourceLockMap;
        synchronized (map) {
            this.mResourceLockMap.clear();
        }
    }

    public void registerMBean(IMBeanRegister register, IMBeanNameProvider name_provider) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String name = name_provider.getMBeanName("Application", "name=ServiceSessionLock");
        register.register(name, (Object)this);
    }

    public static class ResourceLock {
        long mExpireTime;
        String mKey;

        public ResourceLock(String key, long expireTime) {
            this.mExpireTime = expireTime;
            this.mKey = key;
        }

        public int hashCode() {
            return this.mKey.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof String) {
                return this.mKey.equals((String)obj);
            }
            if (obj instanceof ResourceLock) {
                return this.mKey.equals(((ResourceLock)obj).mKey);
            }
            return false;
        }

        public String toString() {
            return "{" + this.mKey + ":" + new Date(this.mExpireTime) + "}";
        }
    }

    public class TimeoutChecker
    extends Thread {
        @Override
        public void run() {
        }
    }

    public static class Unlocker
    implements IResourceReleaser {
        IServiceSessionLock mLock;
        String mSessionID;
        String mService;

        public Unlocker(IServiceSessionLock mLock, String mSessionID, String mService) {
            this.mLock = mLock;
            this.mSessionID = mSessionID;
            this.mService = mService;
        }

        @Override
        public void doRelease(ServiceContext context) {
            this.mLock.unlock(this.mSessionID, this.mService);
        }
    }
}

