/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.json;

import aurora.database.IResultSetConsumer;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;

public class JSONDirectOutputor
implements IResultSetConsumer {
    static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:SS");
    Writer output;
    DateFormat dateFormat;
    int rowid = 0;
    int colid = 0;
    Long totalCount = null;

    public JSONDirectOutputor(Writer w) {
        this(w, DEFAULT_DATE_FORMAT);
    }

    public JSONDirectOutputor(Writer output, DateFormat dateFormat) {
        this.output = output;
        this.dateFormat = dateFormat;
    }

    public String getJSONString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Date) {
            return "\"" + this.dateFormat.format((Date)value) + "\"";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return JSONObject.quote((String)value.toString());
    }

    void writeObjectBegin(String obj_name) throws IOException {
        this.output.write(34);
        this.output.write(obj_name);
        this.output.write("\":");
    }

    void writeSilently(String content) {
        try {
            this.output.write(content);
        }
        catch (IOException ex) {
            this.handle(ex);
        }
    }

    void handle(Exception ex) {
        throw new RuntimeException("Can't write JSON content to output");
    }

    @Override
    public void begin(String root_name) {
        this.rowid = 0;
        this.totalCount = null;
        try {
            this.writeObjectBegin(root_name);
            this.output.write("[");
        }
        catch (IOException ex) {
            this.handle(ex);
        }
    }

    @Override
    public void end() {
        this.writeSilently("] ");
        if (this.totalCount != null) {
            this.writeSilently(", totalCount:" + this.totalCount);
        }
        try {
            this.output.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void endRow() {
        this.writeSilently("} ");
        ++this.rowid;
    }

    @Override
    public Object getResult() {
        return this.output;
    }

    @Override
    public void loadField(String name, Object value) {
        StringBuffer buf = new StringBuffer();
        if (this.colid > 0) {
            buf.append(",");
        }
        buf.append("\"").append(name).append("\":");
        buf.append(this.getJSONString(value));
        this.writeSilently(buf.toString());
        ++this.colid;
    }

    @Override
    public void newRow(String row_name) {
        this.colid = 0;
        if (this.rowid > 0) {
            this.writeSilently(",");
        }
        this.writeSilently("\r\n");
        this.writeSilently("\t{ ");
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public void setRecordCount(long count) {
        this.totalCount = new Long(count);
    }
}

