/*
 * Decompiled with CFR 0.152.
 */
package aurora.service.http;

import aurora.application.action.HttpSessionCopy;
import aurora.application.features.HttpRequestTransfer;
import aurora.service.controller.ControllerProcedures;
import aurora.service.http.HttpServiceInstance;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.SAXException;
import uncertain.cache.CacheFactoryConfig;
import uncertain.cache.ICache;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.event.Configuration;
import uncertain.event.IParticipantManager;
import uncertain.ocm.IObjectRegistry;

public class HttpServiceFactory {
    public static final String KEY_WEB_RESOURCE_CACHE = "WebResource";
    public static final String KEY_PROCEDURE_MAPPING = "procedure-mapping";
    public static final String KEY_PROCEDURE = "procedure";
    public static final String KEY_EXTENSION = "extension";
    static String BUILTIN_PROCEDURE_PACKAGE = ControllerProcedures.class.getPackage().getName();
    static Map BUILTIN_MAPPING = new CompositeMap("procedure-mapping");
    UncertainEngine mUncertainEngine;
    CompositeLoader mCompositeLoader;
    IParticipantManager mParticipantManager;
    Map mProcedureMapping = BUILTIN_MAPPING;
    Configuration mServiceParentConfig;

    static {
        BUILTIN_MAPPING.put("screen", ControllerProcedures.RUN_SCREEN);
        BUILTIN_MAPPING.put("svc", ControllerProcedures.INVOKE_SERVICE);
    }

    private CompositeLoader createCompositeLoader() {
        CompositeLoader l = new CompositeLoader();
        l.setSaveNamespaceMapping(true);
        l.ignoreAttributeCase();
        ICache c = CacheFactoryConfig.getNamedCache((IObjectRegistry)this.mUncertainEngine.getObjectRegistry(), (String)KEY_WEB_RESOURCE_CACHE);
        if (c != null) {
            l.setCache(c);
            l.setCacheEnabled(true);
        }
        return l;
    }

    public HttpServiceFactory(UncertainEngine uncertainEngine) {
        this.mUncertainEngine = uncertainEngine;
        this.mCompositeLoader = this.createCompositeLoader();
        this.mParticipantManager = (IParticipantManager)this.mUncertainEngine.getObjectRegistry().getInstanceOfType(IParticipantManager.class);
        if (this.mParticipantManager != null) {
            this.mServiceParentConfig = this.mParticipantManager.getParticipantsAsConfig("service");
        }
    }

    public CompositeLoader getCompositeLoader() {
        return this.mCompositeLoader;
    }

    public CompositeMap loadServiceConfig(String name) throws IOException, SAXException {
        CompositeMap service_config = this.mCompositeLoader.loadByFile(name);
        return service_config;
    }

    public HttpServiceInstance createHttpService(String name, HttpServletRequest request, HttpServletResponse response, HttpServlet servlet) {
        HttpServiceInstance svc = new HttpServiceInstance(name, this.mUncertainEngine.getProcedureManager());
        svc.setRequest(request);
        svc.setResponse(response);
        svc.setServlet(servlet);
        svc.setRootConfig(this.mServiceParentConfig);
        HttpRequestTransfer.copyRequest(svc);
        HttpSessionCopy.copySession(svc.getContextMap(), request.getSession(false));
        return svc;
    }

    public HttpServiceInstance createHttpService(String name, HttpServiceInstance parent) {
        HttpServiceInstance svc = new HttpServiceInstance(name, this.mUncertainEngine.getProcedureManager());
        svc.setRequest(parent.getRequest());
        svc.setResponse(parent.getResponse());
        svc.setServlet(parent.getServlet());
        svc.setRootConfig(this.mServiceParentConfig);
        svc.setContextMap(parent.getContextMap());
        return svc;
    }

    public void addProcedureMapping(CompositeMap config) {
        this.mProcedureMapping = new CompositeMap(KEY_PROCEDURE_MAPPING);
        Iterator it = config.getChildIterator();
        while (it.hasNext()) {
            CompositeMap item = (CompositeMap)it.next();
            String extension = item.getString((Object)KEY_EXTENSION);
            String procedure = item.getString((Object)KEY_PROCEDURE);
            this.mProcedureMapping.put(extension, procedure);
        }
    }

    public String getProcedureName(String type) {
        return (String)this.mProcedureMapping.get(type);
    }
}

