/*
 * Decompiled with CFR 0.152.
 */
package aurora.security;

import aurora.security.IAccessCheckRuleProvider;
import aurora.security.IAccessRule;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.exception.MessageFactory;
import uncertain.proc.ProcedureRunner;

public class AccessCheck {
    IAccessCheckRuleProvider mRuleProvider;
    String ACCSESS_TAG = "access-check";
    String RULE_NAME_KEY = "name";

    public AccessCheck(IAccessCheckRuleProvider mRuleProvider) {
        this.mRuleProvider = mRuleProvider;
    }

    public void onAccessCheck(ProcedureRunner runner) throws Exception {
        CompositeMap context_map = runner.getContext();
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance(context_map);
        List childs = svc.getServiceConfigData().getChilds();
        for (CompositeMap element : childs) {
            String ruleName;
            if (!"http://www.aurora-framework.org/application".equalsIgnoreCase(element.getNamespaceURI()) || !this.ACCSESS_TAG.equalsIgnoreCase(element.getName()) || (ruleName = element.getString((Object)this.RULE_NAME_KEY)) == null) continue;
            this.doAccessCheck(context_map, ruleName);
        }
    }

    private void doAccessCheck(CompositeMap context_map, String ruleName) throws Exception {
        IAccessRule accsessRule = this.mRuleProvider.getAccessRule(ruleName);
        if (accsessRule == null) {
            throw new IllegalArgumentException("The access-check-rule {" + ruleName + "} is undefined");
        }
        boolean status = accsessRule.isValid(context_map);
        if (!status) {
            throw MessageFactory.createException((String)"aurora.security.access_check_rule_error", null, (Object[])new Object[]{ruleName});
        }
    }
}

