/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.touch;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.touch.Component;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Ajax
extends Component {
    private static final String PROPERTITY_ID = "id";
    private static final String PROPERTITY_TYPE = "type";
    private static final String PROPERTITY_URL = "url";
    private static final String PROPERTITY_TIMEOUT = "timeout";
    private static final String PROPERTITY_ASYNC = "async";
    private static final String PROPERTITY_DATATYPE = "dataType";
    private static final String PARAMETERS = "parameters";
    private static final String EVENTS = "events";

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        Map map = context.getMap();
        CompositeMap model = context.getModel();
        if (view.getString((Object)PROPERTITY_ID) != null) {
            this.addConfig(PROPERTITY_ID, view.getString((Object)PROPERTITY_ID));
        }
        if (view.getString((Object)PROPERTITY_TYPE) != null) {
            this.addConfig(PROPERTITY_TYPE, view.getString((Object)PROPERTITY_TYPE));
        }
        if (view.getString((Object)PROPERTITY_URL) != null) {
            this.addConfig(PROPERTITY_URL, TextParser.parse((String)view.getString((Object)PROPERTITY_URL), (CompositeMap)model));
        }
        if (view.getInt((Object)PROPERTITY_TIMEOUT) != null) {
            this.addConfig(PROPERTITY_TIMEOUT, view.getInt((Object)PROPERTITY_TIMEOUT));
        }
        if (view.getBoolean((Object)PROPERTITY_ASYNC) != null) {
            this.addConfig(PROPERTITY_ASYNC, view.getBoolean((Object)PROPERTITY_ASYNC));
        }
        if (view.getString((Object)PROPERTITY_DATATYPE.toLowerCase()) != null) {
            this.addConfig(PROPERTITY_DATATYPE, view.getString((Object)PROPERTITY_DATATYPE.toLowerCase()));
        }
        this.processParameters(view, model);
        this.processEvents(view);
        map.put("config", this.getConfigString());
    }

    private void processParameters(CompositeMap parent, CompositeMap model) {
        CompositeMap parameters = parent.getChild(PARAMETERS);
        if (parameters != null) {
            Iterator childs = parameters.getChildIterator();
            HashMap<String, JSONObject> datas = new HashMap<String, JSONObject>();
            while (childs.hasNext()) {
                CompositeMap child = (CompositeMap)childs.next();
                String key = child.getString((Object)"name");
                String value = TextParser.parse((String)child.getString((Object)"value"), (CompositeMap)model);
                String bind = child.getString((Object)"bind");
                String dataType = child.getString((Object)"datatype");
                HashMap<String, Object> m = new HashMap<String, Object>();
                if (value != null) {
                    m.put("value", value);
                }
                if (bind != null) {
                    m.put("bind", bind);
                }
                if (dataType != null) {
                    m.put("datatype", dataType);
                    if (value != null && "java.lang.Long".equals(dataType)) {
                        m.put("value", new Long(value));
                    }
                }
                datas.put(key, new JSONObject(m));
            }
            if (!datas.isEmpty()) {
                this.addConfig(PARAMETERS, new JSONObject(datas));
            }
        }
    }

    private void processEvents(CompositeMap parent) {
        CompositeMap events = parent.getChild(EVENTS);
        if (events != null) {
            Iterator childs = events.getChildIterator();
            HashMap datas = new HashMap();
            while (childs.hasNext()) {
                CompositeMap child = (CompositeMap)childs.next();
                String key = child.getString((Object)"name");
                String handler = child.getString((Object)"handler");
                this.addConfig(key, new Component.JSONFunction(this, handler));
            }
        }
    }
}

